/*
 IDBWrapper - A cross-browser wrapper for IndexedDB
 Copyright (c) 2011 - 2013 Jens Arps
 http://jensarps.de/

 Licensed under the MIT (X11) license
*/
(function(j,h,i){"function"===typeof define?define(h):"undefined"!==typeof module&&module.exports?module.exports=h():i[j]=h()})("IDBStore",function(){var j={storeName:"Store",storePrefix:"IDBWrapper-",dbVersion:1,keyPath:"id",autoIncrement:!0,onStoreReady:function(){},onError:function(a){throw a;},indexes:[]},h=function(a,c){for(var b in j)this[b]="undefined"!=typeof a[b]?a[b]:j[b];this.dbName=this.storePrefix+this.storeName;this.dbVersion=parseInt(this.dbVersion,10);c&&(this.onStoreReady=c);this.idb=
window.indexedDB||window.webkitIndexedDB||window.mozIndexedDB;this.keyRange=window.IDBKeyRange||window.webkitIDBKeyRange||window.mozIDBKeyRange;this.consts={READ_ONLY:"readonly",READ_WRITE:"readwrite",VERSION_CHANGE:"versionchange",NEXT:"next",NEXT_NO_DUPLICATE:"nextunique",PREV:"prev",PREV_NO_DUPLICATE:"prevunique"};this.openDB()};h.prototype={version:"1.1.0",db:null,dbName:null,dbVersion:null,store:null,storeName:null,keyPath:null,autoIncrement:null,indexes:null,features:null,onStoreReady:null,
onError:null,_insertIdCount:0,openDB:function(){(this.features={}).hasAutoIncrement=!window.mozIndexedDB;var a=this.idb.open(this.dbName,this.dbVersion),c=!1;a.onerror=function(a){var c=!1;"error"in a.target?c="VersionError"==a.target.error.name:"errorCode"in a.target&&(c=12==a.target.errorCode);if(c)this.onError(Error("The version number provided is lower than the existing one."));else this.onError(a)}.bind(this);a.onsuccess=function(a){if(!c)if(this.db)this.onStoreReady();else if(this.db=a.target.result,
"string"==typeof this.db.version)this.onError(Error("The IndexedDB implementation in this browser is outdated. Please upgrade your browser."));else if(this.db.objectStoreNames.contains(this.storeName))this.store=this.db.transaction([this.storeName],this.consts.READ_ONLY).objectStore(this.storeName),this.indexes.forEach(function(a){var b=a.name;b?(this.normalizeIndexData(a),this.hasIndex(b)?this.indexComplies(this.store.index(b),a)||(c=!0,this.onError(Error('Cannot modify index "'+b+'" for current version. Please bump version number to '+
(this.dbVersion+1)+"."))):(c=!0,this.onError(Error('Cannot create new index "'+b+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")))):(c=!0,this.onError(Error("Cannot create index: No index name given.")))},this),c||this.onStoreReady();else this.onError(Error("Something is wrong with the IndexedDB implementation in this browser. Please upgrade your browser."))}.bind(this);a.onupgradeneeded=function(a){this.db=a.target.result;this.store=this.db.objectStoreNames.contains(this.storeName)?
a.target.transaction.objectStore(this.storeName):this.db.createObjectStore(this.storeName,{keyPath:this.keyPath,autoIncrement:this.autoIncrement});this.indexes.forEach(function(a){var b=a.name;b||(c=!0,this.onError(Error("Cannot create index: No index name given.")));this.normalizeIndexData(a);this.hasIndex(b)?this.indexComplies(this.store.index(b),a)||(this.store.deleteIndex(b),this.store.createIndex(b,a.keyPath,{unique:a.unique,multiEntry:a.multiEntry})):this.store.createIndex(b,a.keyPath,{unique:a.unique,
multiEntry:a.multiEntry})},this)}.bind(this)},deleteDatabase:function(){this.idb.deleteDatabase&&this.idb.deleteDatabase(this.dbName)},put:function(a,c,b){b||(b=function(a){console.error("Could not write data.",a)});c||(c=i);var d=!1,f=null;"undefined"==typeof a[this.keyPath]&&!this.features.hasAutoIncrement&&(a[this.keyPath]=this._getUID());var e=this.db.transaction([this.storeName],this.consts.READ_WRITE);e.oncomplete=function(){(d?c:b)(f)};e.onabort=b;e.onerror=b;a=e.objectStore(this.storeName).put(a);
a.onsuccess=function(a){d=!0;f=a.target.result};a.onerror=b},get:function(a,c,b){b||(b=function(a){console.error("Could not read data.",a)});c||(c=i);var d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?c:b)(f)};e.onabort=b;e.onerror=b;a=e.objectStore(this.storeName).get(a);a.onsuccess=function(a){d=!0;f=a.target.result};a.onerror=b},remove:function(a,c,b){b||(b=function(a){console.error("Could not remove data.",a)});c||(c=i);var d=!1,f=null,e=this.db.transaction([this.storeName],
this.consts.READ_WRITE);e.oncomplete=function(){(d?c:b)(f)};e.onabort=b;e.onerror=b;a=e.objectStore(this.storeName)["delete"](a);a.onsuccess=function(a){d=!0;f=a.target.result};a.onerror=b},batch:function(a,c,b){b||(b=function(a){console.error("Could not apply batch.",a)});c||(c=i);"[object Array]"!=Object.prototype.toString.call(a)&&b(Error("dataArray argument must be of type Array."));var d=this.db.transaction([this.storeName],this.consts.READ_WRITE);d.oncomplete=function(){(g?c:b)(g)};d.onabort=
b;d.onerror=b;var f=a.length,e=!1,g=!1,h=function(){f--;0===f&&!e&&(g=e=!0)};a.forEach(function(a){var c=a.type,f=a.key,g=a.value,a=function(a){d.abort();e||(e=!0,b(a,c,f))};if("remove"==c)g=d.objectStore(this.storeName)["delete"](f),g.onsuccess=h,g.onerror=a;else if("put"==c)"undefined"==typeof g[this.keyPath]&&!this.features.hasAutoIncrement&&(g[this.keyPath]=this._getUID()),g=d.objectStore(this.storeName).put(g),g.onsuccess=h,g.onerror=a},this)},getAll:function(a,c){c||(c=function(a){console.error("Could not read data.",
a)});a||(a=i);var b=this.db.transaction([this.storeName],this.consts.READ_ONLY),d=b.objectStore(this.storeName);d.getAll?this._getAllNative(b,d,a,c):this._getAllCursor(b,d,a,c)},_getAllNative:function(a,c,b,d){var f=!1,e=null;a.oncomplete=function(){(f?b:d)(e)};a.onabort=d;a.onerror=d;a=c.getAll();a.onsuccess=function(a){f=!0;e=a.target.result};a.onerror=d},_getAllCursor:function(a,c,b,d){var f=[],e=!1,g=null;a.oncomplete=function(){(e?b:d)(g)};a.onabort=d;a.onerror=d;a=c.openCursor();a.onsuccess=
function(a){(a=a.target.result)?(f.push(a.value),a["continue"]()):(e=!0,g=f)};a.onError=d},clear:function(a,c){c||(c=function(a){console.error("Could not clear store.",a)});a||(a=i);var b=!1,d=null,f=this.db.transaction([this.storeName],this.consts.READ_WRITE);f.oncomplete=function(){(b?a:c)(d)};f.onabort=c;f.onerror=c;f=f.objectStore(this.storeName).clear();f.onsuccess=function(a){b=!0;d=a.target.result};f.onerror=c},_getUID:function(){return this._insertIdCount++ +Date.now()},getIndexList:function(){return this.store.indexNames},
hasIndex:function(a){return this.store.indexNames.contains(a)},normalizeIndexData:function(a){a.keyPath=a.keyPath||a.name;a.unique=!!a.unique;a.multiEntry=!!a.multiEntry},indexComplies:function(a,c){return["keyPath","unique","multiEntry"].every(function(b){return"multiEntry"==b&&void 0===a[b]&&!1===c[b]?!0:c[b]==a[b]})},iterate:function(a,c){var c=k({index:null,order:"ASC",filterDuplicates:!1,keyRange:null,writeAccess:!1,onEnd:null,onError:function(a){console.error("Could not open cursor.",a)}},c||
{}),b="desc"==c.order.toLowerCase()?"PREV":"NEXT";c.filterDuplicates&&(b+="_NO_DUPLICATE");var d=!1,f=this.db.transaction([this.storeName],this.consts[c.writeAccess?"READ_WRITE":"READ_ONLY"]),e=f.objectStore(this.storeName);c.index&&(e=e.index(c.index));f.oncomplete=function(){if(d)if(c.onEnd)c.onEnd();else a(null);else c.onError(null)};f.onabort=c.onError;f.onerror=c.onError;b=e.openCursor(c.keyRange,this.consts[b]);b.onerror=c.onError;b.onsuccess=function(b){(b=b.target.result)?(a(b.value,b,f),
b["continue"]()):d=!0}},query:function(a,c){var b=[],c=c||{};c.onEnd=function(){a(b)};this.iterate(function(a){b.push(a)},c)},count:function(a,c){var c=k({index:null,keyRange:null},c||{}),b=c.onError||function(a){console.error("Could not open cursor.",a)},d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?a:b)(f)};e.onabort=b;e.onerror=b;e=e.objectStore(this.storeName);c.index&&(e=e.index(c.index));e=e.count(c.keyRange);e.onsuccess=function(a){d=!0;
f=a.target.result};e.onError=b},makeKeyRange:function(a){var c="undefined"!=typeof a.lower,b="undefined"!=typeof a.upper;switch(!0){case c&&b:a=this.keyRange.bound(a.lower,a.upper,a.excludeLower,a.excludeUpper);break;case c:a=this.keyRange.lowerBound(a.lower,a.excludeLower);break;case b:a=this.keyRange.upperBound(a.upper,a.excludeUpper);break;default:throw Error('Cannot create KeyRange. Provide one or both of "lower" or "upper" value.');}return a}};var i=function(){},l={},k=function(a,c){var b,d;
for(b in c)d=c[b],d!==l[b]&&d!==a[b]&&(a[b]=d);return a};h.version=h.prototype.version;return h},this);
