Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');
DeskPRO.Agent.PageFragment.ListPane.Basic = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.Basic,

	initialize: function(html) {
		this.parent(html);

		this.addEvent('activate', function() {
			DeskPRO_Window.updateWindowUrlFragment();
			DeskPRO_Window.getMessageBroker().sendMessage('list-page-fragment.activated', { page: this });
		}, this);
	},

	enableHighlightOpenRows: function(tabtype, id_property, css_prefix) {
		this.addEvent('watchedTabAdded', function(tab) {
			$(css_prefix + tab.page.meta[id_property], this.wrapper || this.el).addClass('open');
		});
		this.addEvent('watchedTabRemoved', function(tab) {
			$(css_prefix + tab.page.meta[id_property], this.wrapper || this.el).removeClass('open');
		});
		DeskPRO_Window.getTabWatcher().addTabTypeWatcher(tabtype, this, true);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
		this.contentWrapper = null;
		this.layout = null;
		this.overlay = null;
		this.appendUrl = null;

		this.resultTypeName = 'basic';
		this.resultTypeId = 'general';
	},

	initPage: function(el) {
		var self = this;
		this.autoAddAjax = {};
		this.wrapper = $(el);

		if (this.meta.filter_id) {
			DeskPRO_Window.sections.tickets_section.highlightFilterNav(this.meta.filter_id, this.meta.topGroupingOption || null);
		}

        $('.extra-fields .agent .agent_link', this.el).on('click', function(ev) {
            var agent_id = $(this).parent().data('prop-value');

            if(agent_id) {
                ev.stopPropagation();
                ev.preventDefault();
                DeskPRO_Window.sections.agent_chat_section.newChatWindow([agent_id]);
            }
        });

		DeskPRO_Window.getMessageBroker().addMessageListener('agent-notification.tickets.unlocked', (function(info) {
			var ticketId = info.ticket_id;
			$('.ticket-' + ticketId, this.contentWrapper).removeClass('locked');
		}).bind(this), null, [this.OBJ_ID]);
		DeskPRO_Window.getMessageBroker().addMessageListener('agent-notification.tickets.locked', (function(info) {
			var ticketId = info.ticket_id;
			$('.ticket-' + ticketId, this.contentWrapper).addClass('locked');
		}).bind(this));

		DeskPRO_Window.getMessageBroker().addMessageListener('tickets.deleted', (function(ticket_ids) {
			var sels = [];
			Array.each(ticket_ids, function(val) {
				this.resultsHelper.removeResultId(val);
				sels.push('article.ticket-' + val);
			}, this);

			sels = sels.join(', ');

			var els = $(sels, this.contentWrapper).addClass('removing').fadeOut(400, function() {
				$(this).remove();
				self.updateTicketCountLabels();
				self.updateUi();
			});

			this.countTotal -= els.length;
		}).bind(this), null, [this.OBJ_ID])

		DeskPRO_Window.getMessageBroker().addMessageListener('agent.ui.ticket_updated', function(info) {
			var ticketId = info.ticket_id;
			self.refreshTicketResults([ticketId]);
		}, null, [this.OBJ_ID]);

		this.contentWrapper = $('.layout-content:first', this.wrapper);

		this._initDisplayOptions();
		this._initFlagMenu();
		this._initGroupingOptions();

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}

		this.performActionsBtn = $('.perform-actions-trigger', this.wrapper);

		var openMassActions = function() {
			if (!self.massActions) {
				self.massActions = new DeskPRO.Agent.TicketList.MassActions(self, {
					isListView: (self.meta.viewType == 'list' ? true : false),
					onPostApply: function() {
						self.selectionBar.checkNone();
					},
					onClosed: function() {
						if (self.massActions) {
							self.massActions.destroy();
						}

						self.selectionBar.checkNone();
						self.massActions = null;
					}
				});
			}

			self.massActions.open();
		};

		self.getEl('perform_actions_btn').on('click', function(ev) {
			Orb.cancelEvent(ev);
			openMassActions();
		});

		var viewType = this.meta.viewType;
		var opt = {
			saveSelectionId: self.meta.filter_id ? ('filter_'+self.meta.filter_id) : null,
			onButtonClick: function() {
				if (viewType != 'list' && DeskPRO_Window.paneVis.tabs) {
					openMassActions();
				}
			},
			onCountChange: function(count) {
				if (viewType != 'list' && DeskPRO_Window.paneVis.tabs) {
					var isOpen = self.massActions && self.massActions.isOpen();

					if (count > 0 && !isOpen) {
						openMassActions();
					} else if (count <= 0 && isOpen) {
						if (self.massActions) {
							self.massActions.close();
						}
					}
				} else {
					if (count > 0) {
						self.getEl('perform_actions_btn').show();
					} else {
						self.getEl('perform_actions_btn').hide();
					}
				}
			}
		};

		if (viewType == 'list') {
			this.wrapper.find('.perform-actions-trigger').on('click', function(ev) {
				Orb.cancelEvent(ev);
				openMassActions();
			});
		}

		if (this.meta.viewType == 'list') {
			opt.selectionBar = $('thead, .selection-bar', el);
		}
		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, opt);
		this.ownObject(this.selectionBar);

		var m = new DeskPRO.UI.Menu({
			triggerElement: $('button.sub-group-trigger:first', this.contentWrapper),
			menuElement: $('ul.sub-group-menu:first', this.contentWrapper)
		});
		this.ownObject(m);

		if (this.meta.groupingIgnore) {
			var groupByMenu = $('.group-by-menu', this.wrapper);
			Array.each(this.meta.groupingIgnore, function(ig) {
				$('[value="' + ig + '"], [data-group-by="' + ig + '"]', groupByMenu).remove();
			});
		}

		var opt = {
			resultIds: this.meta.ticketResultIds,
			perPage: this.meta.perPage || 50,
			currentPage: this.meta.currentPage || 1
		};
		if (this.meta.viewType == 'list') {
			opt.resultRowSelector = 'tr.row-item';
			opt.resultsContainer = $('.table-result-list table', el);
			opt.navEl = $('.bottom-action-bar', el);
		} else {
			opt.resultsContainer = $('> .list-listing', this.getEl('is_results'));
		}

		opt.onPostSetNewResults = function() {
			self.selectionBar.resetCountLabel();
		};
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);

		// We dont need them anymore, and resultsHelper
		// has its own strucutred array anyway,
		// since it could be large we can delete it from memory
		delete this.meta.ticketResultIds;

		if (this.meta.viewType == 'list') {

			this.resultsHelper.options.postSetNewResults = function() {
				self.selectionBar.controlCheck = self.wrapper.find('.selection-control');
				self.selectionBar.controlCheck.on('click', function() {
					if ($(this).is(':checked')) {
						self.selectionBar.checkAll();
					} else {
						self.selectionBar.checkNone();
					}
				});
			};

			$('.list-grouping-bar', this.wrapper).on('click', 'a[data-route]', function(ev) {
				ev.stopPropagation();
				ev.preventDefault();

				var route = $(this).data('route');
				self.loadNewListviewUrl(route.replace('listpane:', '') + '&view_type=list');
			});
		}

		this.enableHighlightOpenRows('ticket', 'ticket_id', '.row-item.ticket-');
		this.countTotal = parseInt(this.getEl('total_count').text().trim()) || 0;

		if (this.meta.viewType != 'list') {
			this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);
		}

		this.selectionBar.restoreFromSessionStorage();
	},

	addTicketResults: function(ticketIds) {
		var i;
		for (i = 0; i < ticketIds.length; i++) {
			this._removeTicketResult(ticketIds[i]);
		}
	},

	_addTicketResult: function(ticketId) {
		if (this.resultsHelper) this.resultsHelper.options.refreshMode = true;
		var self = this;
		self.reloadIfStale = false;
		var row = $('article.ticket-' + ticketId, self.contentWrapper);
		if (row[0] && row.hasClass('removing')) {
			return false;
		}

		// If a ticket has been updated, it's not on our list, and we're viewing a sub-groupging,
		// we need to reload the whole list to know if the ticket was added
		if (self.meta.topGroupingTerm) {
			var li = $('#system_filters_wrap').find('.nav-selected');
			if (!li[0]) {
				$('#tickets_outline_custom_filters').find('.nav-selected');
			}

			if (!li[0]) {
				return false;
			}

			// See DeskPRO/Agent/WindowElement/Section/Tickets.js
			// is-stale is added when the counts were updated, which means
			// the list we're looking at is now out of date, meaning we need to relaod
			if (li.hasClass('is-stale')) {
				if (self.meta.routeData && self.meta.routeData.route) {
					DeskPRO_Window.runPageRoute(self.meta.routeData.route, {noChangePaneVis: true, isBackgroundLoad: true});
				}
			}

			// This might be run after is-stale (order is undefined based on event delegation),
			// so the list needs to know if to reload too
			self.reloadIfStale = true;

			if (!row[0]) {
				return false;
			}
		}

		if (self.meta.groupBy) {
			if (self.meta.routeData && self.meta.routeData.route) {
				DeskPRO_Window.runPageRoute(self.meta.routeData.route, {noChangePaneVis: true, isBackgroundLoad: true});
			}
		}

		self.addTicketResults([ticketId]);
		return true;
	},

	_handleResize: function() {
		if (!this.layout) return;
		this.layout.resizeAll();
	},

	addTicketResults: function(ticketIds) {
		this.refreshTicketResults(ticketIds, true);
	},

	refreshTicketResults: function(ticket_ids, is_adding) {
		var i;
		for (i = 0; i < ticket_ids.length; i++) {
			this._removeTicketResult(ticket_ids[i], is_adding);
		}
	},

	_refreshTicketResult: function(ticket_id, is_adding) {
		var self = this;
		if (!this.meta.loadSingleUrl) {
			return;
		}

		var replace_existing = !is_adding

		var exist = self.getEl('results_wrap').find('article.ticket-' + ticket_id);
		if (exist[0] && exist.hasClass('removing')) {
			return;
		}

		this.resultsHelper.prependResultId(ticket_id);

		if (this.resultsHelper.getCurrentPage() == 1) {
			var url = this.meta.loadSingleUrl.replace('$ticket_id', ticket_id).replace('$view_type', this.meta.viewType || '');

			if (replace_existing) {
				var exist = self.getEl('results_wrap').find('article.ticket-' + ticket_id);
				if (!exist[0] || exist.hasClass('removing')) {
					return;
				}
			}

			this.autoAddAjax[ticket_id] = $.ajax({
				url: url,
				dataType: 'html',
				context: this,
				complete: function() {
					if (this.autoAddAjax[ticket_id]) delete this.autoAddAjax[ticket_id];
				},
				success: function(html) {
					var el = $(html);

					var ticketRow = el.find('article.row-item');
					var ticketId = ticketRow.data('ticket-id');
					if (ticketId) {
						var tabs = DeskPRO_Window.tabWatcher.findTabType('ticket');
						Array.each(tabs, function(t) {
							if (t.page.meta.ticket_id == ticket_id) {
								ticketRow.addClass('open');
								return false;
							}
						});
					}

					$('.timeago', el).timeago();

					var exist = self.getEl('results_wrap').find('article.ticket-' + ticket_id);

					if (replace_existing && !exist[0]) {
						return;
					}
					if (exist[0] && exist.hasClass('removing')) {
						return;
					}

					if (exist[0] && replace_existing) {

						if (!el.is('.row-item')) {
							el = el.find('.row-item');
							el.hide();
							el.detach();
						}

						exist.after(el);
						exist.remove();
						el.show();
					} else {
						if (exist[0]) {
							exist.remove();
						}

						self.getEl('results_wrap').prepend(el);
						el.slideDown('fast', self.updateUi.bind(self));

						this.countTotal++;
						this.updateTicketCountLabels();
					}
				}
			});
		}
	},

	_removeTicketResult: function(ticket_id) {
		var self = this;
		if (this.resultsHelper) this.resultsHelper.options.refreshMode = true;
		var el = $('.ticket-' + ticket_id, this.contentWrapper);

		if (this.autoAddAjax[ticket_id]) {
			this.autoAddAjax[ticket_id].abort();
			if (this.autoAddAjax[ticket_id]) delete this.autoAddAjax[ticket_id];
		}

		if (!el[0]) {
			return;
		}

		el.addClass('removing');
		el.animate({ height: 'toggle', opacity: 'toggle' }, 'slow', function() {
			self.resultsHelper.removeResultId(ticket_id);
			el.remove();
			self.countTotal--;
			self.updateTicketCountLabels();
			self.updateUi();
		});
	},

	removeTicketResults: function(ticket_ids) {
		var i;
		for (i = 0; i < ticket_ids.length; i++) {
			this._removeTicketResult(ticket_ids[i]);
		}
	},

	updateTicketCountLabels: function() {

		var showing = $('article.row-item', this.wrapper).length || 0;

		if (this.countTotal < 0) {
			this.countTotal = 0;
		}

		if (this.countTotal < 1) {
			this.getEl('is_results').hide();
			this.getEl('no_results').show();

			this.getEl('total_count').text(this.countTotal);
			this.wrapper.find('.results-count-display').text(this.countTotal);
		} else {

			if (!this.resultsHelper) {
				return;
			}

			// If there is no results element, it means the list was loaded with no results
			// and the various control elements havent been rendered.
			// So we need to refresh the view
			if (!this.getEl('is_results').length) {
				DeskPRO_Window.loadListPane(this.meta.refreshUrl, {noChangePaneVis: true, isBackgroundLoad: true});
				return;
			}

			this.getEl('no_results').hide();
			this.getEl('is_results').show();

			// If no results helper, then this view
			// has been destroyed (but this callback was called before)
			if (!this.resultsHelper) {
				return;
			}

			var lowerBounds = ((this.resultsHelper.currentPage-1) * this.resultsHelper.options.perPage) + 1;
			var upperBounds = (lowerBounds-1) + showing;
			if (upperBounds > this.countTotal) {
				upperBounds = this.countTotal;
			}

			this.getEl('showing_count').text(lowerBounds + '-' + upperBounds);
			this.getEl('total_count').text(this.countTotal);
			this.wrapper.find('.results-count-display').text(this.countTotal);
			$('span', this.getEl('total_grouped_count')).text(this.countTotal);
			this.selectionBar.resetCountLabel();
		}
	},

	//#########################################################################
	//# Edit Search buttons
	//#########################################################################

	_initSearchOptions: function() {
		var editBtn = $('.summary .edit', this.topSection);
		editBtn.on('click', this.showSearchForm.bind(this));

		var form = $('form.ticket-search-form', this.topSection);
		form.on('submit', function(ev) {
			ev.preventDefault();

			var url = form.attr('action');
			var data = form.serializeArray();

			DeskPRO_Window.loadListPane(url, { postData: data });
		});
	},

	showSearchForm: function() {
		var criteriaList  = $('.search-form', this.topSection);
		var criteriaTerms = $('.search-builder-tpl', this.topSection);

		var editor = new DeskPRO.Form.RuleBuilder(criteriaTerms);
		this.ownObject(editor);

		$('.add-term', criteriaList).data('add-count', 0).on('click', function() {
			var count = parseInt($(this).data('add-count'));
			var basename = 'terms['+count+']';

			$(this).data('add-count', count+1);

			editor.addNewRow($('.search-terms', criteriaList), basename);
		});

		var searchDataEl = $('.search-form-data:first', this.topSection);
		if (searchDataEl.length) {
			var searchData = searchDataEl.get(0).innerHTML;
			searchData = $.parseJSON(searchData);

			if (searchData.terms) {
				Array.each(searchData.terms, function(info, x) {
					var basename = 'terms[initial_' + x + ']';
					editor.addNewRow($('.search-terms', criteriaList), basename, {
						type: info.type,
						op: info.op,
						options: info.options
					});
				});
			}

			if (searchData.order_by) {
				$('[name="order_by"]', this.topSection).val(searchData.order_by);
			}

			searchDataEl.remove();
		}

		$('.summary', this.topSection).slideUp();
		$('.form-panel', this.topSection).slideDown();
	},

	//#########################################################################
	//# Grouping buttons
	//#########################################################################

	_initGroupingOptions: function() {

		var self = this;
		$('div.search-top ul.grouping-info > li[data-group-id]', this.contentWrapper).on('click', function() {
			self.switchToSubgroup($(this).data('group-id'), $(this));
		});
	},

	switchToSubgroup: function(field_id, el) {

		if (field_id == 'NONE') {
			this.appendUrl = null;
		} else {
			this.appendUrl = '&group_field_id=' + field_id;
		}

		$('table.list tbody', this.contentWrapper).remove();
		this.loadResultPage(1);

		$('div.search-top ul.grouping-info > li', this.contentWrapper).removeClass('on');

		if (el) {
			el.addClass('on');
		}
	},

	//#########################################################################
	//# Flag menu
	//#########################################################################

	_initFlagMenu: function() {
		var self = this;
		this.flagMenu = new DeskPRO.UI.Menu({
			menuElement: $('> ul.ticket-flag-menu:first', this.contentWrapper),
			onItemClicked: function(info) {
				self._handleFlagMenuClick(info);
			}
		});
		this.ownObject(this.flagMenu);

		$('table.list:first', this.contentWrapper).on('click', 'span.ticket-flag', function(ev) {
			self.flagMenu.openMenu(ev);
		});
	},

	_handleFlagMenuClick: function(info) {

		var item = $(info.itemEl);
		var flag = item.data('flag');

		var m = $(info.menu.getOpenTriggerElement());
		var ticketId = m.parent().parent().data('ticket-id');
		if (!ticketId) {
			return;
		}

		var old_flag = m.data('flag');

		m.removeClass('icon-flag-'+old_flag);
		m.addClass('icon-flag-'+flag);
		m.data('flag', flag);

		$.ajax({
			url: BASE_URL + 'agent/tickets/' + ticketId + '/ajax-save-flagged',
			type: 'POST',
			context: this,
			data: { color: flag },
			dataType: 'json',
			success: function(data) {

			}
		});
	},

	//#########################################################################
	//# Display options
	//#########################################################################

	_initDisplayOptions: function() {

		var self = this;

		$('.detail-view-trigger', this.contentWrapper).on('click', function() {
			self.switchViewType('list');
		});

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'ticket-' + this.resultTypeName,
			resultId: this.resultTypeId,
			refreshUrl: this.meta.refreshUrl,
			isListView: (this.meta.viewType == 'list' ? true : false)
		});
		this.ownObject(this.displayOptions);

		// Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by');
				var label = item.find('.label').text().trim();

				// Change the displayed label for some visual feedback
				$('.label label', sortMenuBtn).text(label);
				sortMenuBtn.find('.order-dir').hide();
				sortMenuBtn.find('.order-dir.' + prop.split('_').pop()).show();


				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

                if(self.wrapper.find('header.list-grouping-bar').css('display') == 'block') {
                    self.wrapper.find('header.list-grouping-bar').hide();
                    self.getEl('grouping_loading').show();
                }

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);

		var groupMenuBtn = $('.group-by-menu-trigger', this.wrapper).first();
		this.groupingMenu = new DeskPRO.UI.Menu({
			triggerElement: groupMenuBtn,
			menuElement: $('.group-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('group-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', groupMenuBtn).text(label);

				var url = self.meta.refreshUrl;
				url = Orb.appendQueryData(url, 'group_by', prop);

				if (self.meta.viewType == 'list') {
					self.loadNewListviewUrl(url +'&view_type=list');
				} else {
					self.wrapper.find('header.list-grouping-bar').hide();
					self.getEl('grouping_loading').show();
					DeskPRO_Window.loadListPane(url);
				}
			}
		});
		this.ownObject(this.groupingMenu);
	},

	switchViewType: function(view_type) {

		var new_url = this.meta.viewTypeUrl.replace('$view_type', view_type);

		if (view_type == 'list') {
			var oldlist = this.listview;
			this.listview = new DeskPRO.Agent.TicketList.ListView(this);

			if (oldlist && !oldlist.OBJ_DESTROYED) {
				this.listview.addEvent('ajaxLoaded', function() {
					if (!oldlist.OBJ_DESTROYED) {
						oldlist.destroy();
					}
				});
			}

			this.listview.open();
			return;
		}

		DeskPRO_Window.loadListPane(new_url, null, function() {
			DeskPRO_Window.removePage(self);
		});
	},

	loadNewListviewUrl: function(new_url) {
		var oldlist = this.listview;
		this.listview = new DeskPRO.Agent.TicketList.ListView(this, { load_url: new_url });

		if (oldlist && !oldlist.OBJ_DESTROYED) {
			oldlist.showInnerLoading();
			this.listview.addEvent('ajaxLoaded', function() {
				if (!oldlist.OBJ_DESTROYED) {
					oldlist.destroy();
				}
			});
		}

		oldlist.close();
		this.listview.open();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketFilter = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults,

	initializeProperties: function() {
		this.TYPENAME = 'ticket-filter';

		this.resultTypeName = 'filter';
		this.resultTypeId = 0;
	},

	initPage: function(el) {

		DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'filter', id: this.getMetaData('filter_id'), topGroupingOption: this.meta.topGroupingOption || null });
		this.resultTypeId = this.getMetaData('filter_id');
		this.parent(el);
	},

	activate: function() {
		if (this.getMetaData('filter_id')) {
			DeskPRO_Window.getMessageBroker().sendMessage('filter.view-activated', this.getMetaData('filter_id'));
		}
	},

	deactivate: function() {
		if (this.getMetaData('filter_id')) {
			DeskPRO_Window.getMessageBroker().sendMessage('filter.view-deactivated', this.getMetaData('filter_id'));
		}
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.OrganizationList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'org-list';
		this.wrapper = null;
		this.contentWrapper = null;
		this.overlay = null;
		this.appendUrl = null;
		this.actionsBarHelper = null;
		this.resultTypeName = 'filter';
		this.resultTypeId = 0;
	},

	initPage: function(el) {

		var self = this;

		this.wrapper = $(el);
		this.contentWrapper = $('div.content:first', this.wrapper);

		this.resultTypeId = this.meta.cache_id || 0;

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'org-filter',
			resultId: this.resultId,
			refreshUrl: this.meta.refreshUrl
		});
		this.ownObject(this.displayOptions);

		this.enableHighlightOpenRows('organization', 'org_id', 'article.org-');

		var opt = {
			resultIds: this.meta.orgResultIds,
			perPage: this.meta.perPage || 50
		};
		if (this.meta.viewType && this.meta.viewType == 'list') {
			opt.resultRowSelector = 'tr.row-item';
			opt.resultsContainer = $('.table-result-list table', el);
			opt.navEl = $('.bottom-action-bar', el);
		}
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);

		delete this.meta.orgResultIds;

		// Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PeopleList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'people-list';
		this.wrapper = null;
		this.contentWrapper = null;
		this.overlay = null;
		this.appendUrl = null;
		this.actionsBarHelper = null;
		this.resultTypeName = 'filter';
		this.resultTypeId = 0;
	},

	initPage: function(el) {

		var self = this;

		this.wrapper = $(el);
		this.contentWrapper = $('div.content:first', this.wrapper);

		this.resultTypeId = this.meta.cache_id || 0;

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'people-filter',
			resultId: this.resultId,
			refreshUrl: this.meta.refreshUrl,
			isListView: (this.meta.viewType == 'list' ? true : false)
		});
		this.ownObject(this.displayOptions);

		// Sorting options

		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			/*onCountChange: function(count) {
				var isOpen = self.massActionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.massActionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.massActionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		$('.detail-view-trigger', this.wrapper).on('click', (function() {
			this.switchViewType('list');
		}).bind(this));

		this.massActionsMenu = new DeskPRO.UI.Menu({
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			menuElement: $('.actions-menu:first', this.wrapper),
			onItemClicked: function(info) {
				var itemEl = $(info.itemEl);
				var menuEl = itemEl.parent();
				var action = itemEl.data('action');

				if (menuEl.is('.submenu')) {
					action = menuEl.data('action');
				}

				var postData = self.selectionBar.getCheckedFormValues('ids');
				var removeFromList = false;

				switch (action) {
					case 'delete':

						break;

					case 'add-to-organization':
						var id = itemEl.data('organization-id');
						if (!id) {
							return;
						}

						postData.push({
							name: 'organization_id',
							value: id
						});
						break;

					case 'del-from-organization':

						break;

					case 'add-to-usergroup':
						var id = itemEl.data('usergroup-id');
						if (!id) {
							return;
						}

						postData.push({
							name: 'usergroup_id',
							value: id
						});
						break;

					case 'del-from-usergroup':
						var id = itemEl.data('usergroup-id');
						if (!id) {
							return;
						}

						postData.push({
							name: 'usergroup_id',
							value: id
						});
						break;

					default:
						return;
						break;
				}

				$.ajax({
					url: BASE_URL + 'agent/feedback/filter/mass-actions/' + action,
					data: postData,
					type: 'POST',
					dataType: 'json',
					success: function(data) {
						if (removeFromList) {
							self.selectionBar.getChecked().parent().fadeOut('fast');
						} else {
							self.selectionBar.getChecked().each(function() {
								var name = $('.subject', $(this).parent());
								DeskPRO_Window.util.showSavePuff(name);
							});
						}

						self.selectionBar.checkNone();
					}
				});
			}
		});
		this.ownObject(this.massActionsMenu);

		this.enableHighlightOpenRows('person', 'person_id', 'article.person-');

		var opt = {
			resultIds: this.meta.peopleResultIds,
			perPage: this.meta.perPage || 50
		};
		if (this.meta.viewType == 'list') {
			opt.resultRowSelector = 'tr.row-item';
			opt.resultsContainer = $('.table-result-list table', el);
			opt.navEl = $('.bottom-action-bar', el);
		}
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);

		// We dont need them anymore, and resultsHelper
		// has its own strucutred array anyway,
		// since it could be large we can delete it from memory
		delete this.meta.peopleResultIds;

		if (this.meta.viewType != 'list') {
			this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);
		}

		this.wrapper.on('click', 'button.agent-confirm-approve', function(ev) {
			ev.preventDefault();
			var el = $(this);
			DeskPRO_Window.util.ajaxWithClientMessages({
				url: BASE_URL + 'agent/people/validate/approve',
				data: { 'people_ids[]': el.data('person-id') },
				success: function() {
					DeskPRO_Window.getMessageBroker().sendMessage('agent.person.confirmed', { person_id: el.data('person-id') });
					el.closest('.validation-row').remove();
					self.updateUi();
				}
			});
		});
		this.wrapper.on('click', 'button.agent-confirm-delete', function(ev) {
			ev.preventDefault();
			var el = $(this);
			DeskPRO_Window.util.ajaxWithClientMessages({
				url: BASE_URL + 'agent/people/validate/delete',
				data: { 'people_ids[]': el.data('person-id') },
				success: function() {
					DeskPRO_Window.getMessageBroker().sendMessage('agent.person.removed', { person_id: el.data('person-id') });
					el.closest('article.row-item').remove();
					self.updateUi();
				}
			});
		});

		DeskPRO_Window.getMessageBroker().addMessageListener('agent.person.removed', function(info) {
			var row = self.wrapper.find('article.person-' + info.person_id);
			row.remove();
			self.updateUi();
		});
		DeskPRO_Window.getMessageBroker().addMessageListener('agent.person.confirmed', function(info) {
			var row = self.wrapper.find('article.person-' + info.person_id);
			row.find('.validation-row').remove();
			self.updateUi();
		});
	},

	destroyPage: function() {

	},

	switchViewType: function(view_type) {

		var new_url = this.meta.viewTypeUrl.replace('$view_type', view_type);

		if (view_type == 'list') {
			var oldlist = this.listview;
			this.listview = new DeskPRO.Agent.PageHelper.PeopleList.ListView(this);

			if (oldlist && !oldlist.OBJ_DESTROYED) {
				this.listview.addEvent('ajaxLoaded', function() {
					if (!oldlist.OBJ_DESTROYED) {
						oldlist.destroy();
					}
				});
			}

			this.listview.open();
			return;
		}

		DeskPRO_Window.loadListPane(new_url, null, function() {
			DeskPRO_Window.removePage(self);
		});
	},

	loadNewListviewUrl: function(new_url) {
		var oldlist = this.listview;
		this.listview = new DeskPRO.Agent.PageHelper.PeopleList.ListView({ load_url: new_url });

		if (oldlist && !oldlist.OBJ_DESTROYED) {
			oldlist.showInnerLoading();
			this.listview.addEvent('ajaxLoaded', function() {
				if (!oldlist.OBJ_DESTROYED) {
					oldlist.destroy();
				}
			});
		}

		this.listview.open();
	},

	saveDisplayOptions: function() {

		$('.loading-off', this.displayOptionsWrapper).hide();
		$('.loading-on', this.displayOptionsWrapper).show();

		var data = [];
		var pref_name = 'prefs[agent.ui.people-'+ this.resultTypeName + '-display-fields.' + this.resultTypeId +'][]';

		$('input[type="checkbox"]:checked', this.displayOptionsList).each(function() {
			data.push({
				name: pref_name,
				value: $(this).attr('name')
			});
		});


		// and the ordering
		data.push({
			name: 'prefs[agent.ui.people-'+ this.resultTypeName + '-order-by.' + this.resultTypeId +']',
			value: $('select[name="order_by"]', this.displayOptionsWrapper).val()
		});

		// We reload the same page which will have changes applied
		var url = this.getMetaData('refreshUrl');
		if (this.appendUrl) {
			url += this.appendUrl;
		}

		var self = this;

		$.ajax({
			timeout: 20000,
			type: 'POST',
			url: this.getMetaData('saveListPrefsUrl'),
			data: data,
			success: function() {

				DeskPRO_Window.loadListPane(url, null, function() {
					DeskPRO_Window.removePage(self);
				});

			}
		});
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketFlagged = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'ticket-flagged';

		this.resultTypeName = 'flagged';
		this.resultTypeId = 0;
	},

	initPage: function(el) {

		this.meta['view_name'] = 'flag';
		this.meta['view_extra'] = this.getMetaData('flag');

		DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults.prototype.initPage.apply(this, [el]);
		this.resultTypeId = this.getMetaData('flag');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketDeletedList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'ticket-deleted-list';

		this.resultTypeName = 'filter';
		this.resultTypeId = 0;
	},

	initPage: function(el) {
		this.parent(el);
		this.resultTypeId = this.getMetaData('cache_id');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketCustomFilter = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults,

	initPage: function(el) {

		if (this.getMetaData('view_label')) {
			DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'label', id: this.getMetaData('label') });
		} else if (this.getMetaData('view_flag')) {
			DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'flag', id: this.getMetaData('flag') });
		} else if (this.getMetaData('view_spam')) {
			DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'archive', id: this.getMetaData('spam') });
		} else if (this.getMetaData('view_validating')) {
			DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'archive', id: this.getMetaData('validating') });
		} else if (this.getMetaData('view_recycle_bin')) {
			DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'archive', id: this.getMetaData('recycle_bin') });
		}


		this.parent(el);
		this.resultTypeId = this.getMetaData('cache_id');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketCustomFilterForm = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {

		this.wrapper = $(el);

		this._initBasic();
		this._initFilterForm();

		if (this.getMetaData('autorun')) {
			this.submitForm();
		}
	},

	destroyPage: function() {

	},

	_initBasic: function() {
		var self = this;
		$('> .summary > .toggle', this.wrapper).on('click', function() {
			$('> .summary', self.wrapper).hide();
			$('> .criteria', self.wrapper).slideDown();
		});
	},

	_initFilterForm: function() {
		var self = this;

		var editor = new DeskPRO.Form.RuleBuilder($('.search-tpl', this.wrapper));
		editor.addEvent('newRow', function(new_row) {
			$('.remove', new_row).on('click', function() {
				new_row.remove();
			});
		});
		$('.search-form .add-term').data('add-count', 0).on('click', function() {
			var count = parseInt($(this).data('add-count'));
			var basename = 'terms['+count+']';

			$(this).data('add-count', count+1);

			editor.addNewRow($('.search-form .search-terms', self.wrapper), basename);
		});

		var self = this;
		$('button.run-filter-trigger', this.wrapper).on('click', function() {
			self.submitForm();
		});

		if (this.getMetaData('preselectTerms')) {
			var count = 0;
			var preselectTerms = this.getMetaData('preselectTerms');
			for (var i = 0; i < preselectTerms.length; i++) {
				if (!preselectTerms[i]) continue;

				editor.addNewRow(
					$('.search-form .search-terms', self.wrapper),
					'terms['+count+']',
					preselectTerms[i]
				);
			}

			$('.search-form .add-term', this.wrapper).data('add-count', count);
		}
	},

	submitForm: function() {

		var data = $('form.search-form-data', this.wrapper).serializeArray();

		$.ajax({
			cache: false,
			type: 'POST',
			data: data,
			url: this.getMetaData('formSubmitUrl'),
			context: this,
			dataType: 'html',
			success: function (data) {
				$(' .criteria', this.wrapper).hide();
				$('.summary', this.wrapper).show();
				this._handleAjaxResults(data);
			}
		});
	},

	_handleAjaxResults: function(data) {

		DeskPRO_Window.removePage(this);

		var page = DeskPRO_Window.createPageFragment(data);
		DeskPRO_Window.addListPage(page);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TicketSla = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.BasicTicketResults,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'ticket-sla';

		this.resultTypeName = 'sla';
		this.resultTypeId = 0;
	},

	initPage: function(el) {

		DeskPRO_Window.getMessageBroker().sendMessage('ticket-section.list-activated', { listType: 'sla', id: this.getMetaData('sla_id'), topGroupingOption: this.meta.topGroupingOption || null });
		this.resultTypeId = this.getMetaData('sla_id');
		this.parent(el);
	},

	activate: function() {
		if (this.getMetaData('sla_id')) {
			DeskPRO_Window.getMessageBroker().sendMessage('sla.view-activated', this.getMetaData('sla_id'));
		}
	},

	deactivate: function() {
		if (this.getMetaData('sla_id')) {
			DeskPRO_Window.getMessageBroker().sendMessage('sla.view-deactivated', this.getMetaData('sla_id'));
		}
	},

	updateSlaListForTicket: function(info) {
		if (!info.ticket_id || !info.sla_id) {
			return;
		}

		// run this for every SLA change, as a ticket may have multiple SLAs
		// and the general status could change
		// todo: in the future we could possibly resolve this without always
		// refreshing if we look at the list and only update if there's a ticket
		// with this SLA
		this.refreshSlaTicketList();
	},

	refreshSlaTicketList: function() {
		var self = this;

		if (this.isRefreshing) {
			return;
		}
		this.isRefreshing = true;

		setTimeout(function() {
			self.isRefreshing = false;
			DeskPRO_Window.loadListPane(self.meta.refreshUrl);
		}, 0);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.RecycleBin = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'recyclebin';
		this.wrapper = null;
		this.contentWrapper = null;
		this.barWrapper = null;
		this.layout = null;
		this.overlay = null;
		this.appendUrl = null;
		this.actionsBarHelper = null;
		this.resultTypeName = 'basic';
		this.resultTypeId = 'general';
		this.changeManager = null;
		this.loadFirst = false;
	},

	initPage: function(el) {

		this.wrapper = el;

		var self = this;
		$('.type-list', el).each(function() {
			self.initTypeList($(this));
		});

		$('time.timeago', this.wrapper).timeago();

	},

	initTypeList: function(listWrap) {
		var type = listWrap.data('load-name');

		var self = this;
		$('.list-load-more', listWrap).on('click', function() {
			self.loadMore(type);
		});
	},

	loadMore: function(loadName) {
		var wrap = $('.' + loadName + '-list.type-list', this.wrapper);
		var table = $('table:first', wrap);
		var loadBtn  = $('.list-load-more', wrap);

		var lastTbody = $('tbody:last', table);
		var nextPage = parseInt(lastTbody.data('page')) + 1;

		$.ajax({
			url: BASE_URL + 'agent/recycle-bin/' + loadName + '/' + nextPage,
			dataType: 'json',
			success: function(data) {
				if (data.no_more_results) {
					loadBtn.hide();
				}

				if (data.count < 1) {
					return;
				}

				var rows = $(data.htmls);
				$('time.timeago', rows).timeago();

				table.append(rows);
			}
		});
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.KbPendingArticles = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		this.actionsMenu = new DeskPRO.UI.Menu({
			menuElement: $('ul.actions-menu:first', this.wrapper),
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			onItemClicked: function(info) {
				var ids = self.selectionBar.getCheckedValues();
				var els = [];

				var formData = [];
				Array.each(ids, function(id) {
					formData.push({
						name: 'ids[]',
						value: id
					});

					els.push($('article.pending-article-' + id + ':first', self.wrapper).get(0));
				});

				$(els).fadeOut();

				var action = $(info.itemEl).data('action');

				$.ajax({
					url: BASE_URL + 'agent/kb/pending-articles/mass-actions/' + action,
					data: formData,
					type: 'POST',
					dataType: 'json',
					error: function() {
						$(els).show();
					},
					success: function() {
						$(els).remove();
						DeskPRO_Window.util.modCountEl('#kb_pending_count', '-', els.length);
					}
				});
			}
		});
		this.ownObject(this.actionsMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function(ev) {
				self.actionsMenu.open(ev);
			}/*,
			onCountChange: function(count) {
				var isOpen = self.actionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.actionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.actionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		DeskPRO_Window.getMessageBroker().addMessageListener('kb.pending_article_removed', function(data) {
			self.removeFromList(data.pending_article_id);
		});

		var newFormOverlay = new DeskPRO.UI.Overlay({
			contentElement: this.getEl('add_new_overlay'),
			zIndex: 'top'
		});

		$('.add-new-trigger', this.el).on('click', function() {
			newFormOverlay.open();
		});
		$('.save-new-trigger', this.getEl('add_new_overlay')).on('click', function() {
			self.saveNewPendingArticle();
			newFormOverlay.close();
		});

		$('section.pending-articles-list', this.wrapper).on('click', '.pending-delete', function(ev) {
			ev.stopPropagation();
			var row = $(this);
			var x = 0;
			while (!row.is('article')) {
				if (x++ > 10) return;
				row = row.parent();
			}

			row.slideUp('fast');

			var id = $('input.item-select', row).val();

			$.ajax({
				url: BASE_URL + 'agent/kb/pending-articles/' + id + '/remove',
				type: 'POST',
				dataType: 'json',
				error: function() {
					row.show();
				},
				success: function() {
					row.remove();
					DeskPRO_Window.util.modCountEl('#kb_pending_count', '-');
				}
			});
		});

		$('section.pending-articles-list', this.wrapper).on('click', '.pending-create', function(ev) {
			ev.stopPropagation();
			var row = $(this);
			var x = 0;
			while (!row.is('article')) {
				if (x++ > 10) return;
				row = row.parent();
			}

			var id = $('input.item-select', row).val();
			var ticketRoute = $('input.item-select', row).data('ticket-route');

			$.ajax({
				url: BASE_URL + 'agent/kb/pending-articles/' + id + '/info',
				type: 'POST',
				dataType: 'json',
				success: function(data) {
					if (ticketRoute) {
						DeskPRO_Window.runPageRoute(ticketRoute);
					}

					if (DeskPRO_Window.newArticleLoader) {
						DeskPRO_Window.newArticleLoader.open(function(page) {
							page.setPendingArticle(data);

							if (data.ticket_id) {
								var closeTicketId = data.ticket_id;
								page.addEvent('destroy', function() {
									Object.each(DeskPRO_Window.TabBar.getTabs(), function(tab, id) {
										if (tab.page && tab.page.meta.ticket_id == closeTicketId) {
											DeskPRO_Window.removePage(tab.page);
										}
									});
								});
							}
						});
					}
				}
			});
		});
	},

	saveNewPendingArticle: function() {
		var formWrap = this.getEl('add_new_overlay');
		var val = $('textarea', this.getEl('add_new_overlay')).val().trim();

		if (!val) {
			formWrap.slideUp();
			return;
		}

		var data = [];
		data.push({
			name: 'comment',
			value: val
		});

		$.ajax({
			url: BASE_URL + 'agent/kb/pending-articles/new',
			type: 'POST',
			data: data,
			context: this,
			dataType: 'json',
			success: function(info) {

				$('textarea:first', formWrap).val('');
				formWrap.slideUp();

				var addEl = $(info.row_html);
				$('section.pending-articles-list', this.wrapper).prepend(addEl);

				DeskPRO_Window.util.modCountEl('#kb_pending_count', '+');
			}
		});
	},

	removeFromList: function(id) {
		$('article.pending-article-' + id, this.wrapper).slideUp('fast');
		DeskPRO_Window.util.modCountEl('#kb_pending_count', '-');
		DeskPRO_Window.util.modCountEl(this.getEl('count'), '-');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.KbValidatingArticles = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		this.wrapper = el;

		var self = this;
		$('a.view-link.edit', this.wrapper).on('click', function(ev) {
			ev.preventDefault();
			self.loadPreviewEdit($(this).attr('href'));
		});

		$('a.view-link.article', this.wrapper).on('click', function(ev) {
			ev.preventDefault();
			self.loadPreviewArticle($(this).attr('href'));
		});
	},

	loadPreviewEdit: function(url) {

		var self = this;

		var overlay = new DeskPRO.UI.Overlay({
			destroyOnClose: true,
			contentMethod: 'ajax',
			contentAjax: {
				url: url,
				type: 'GET',
				context: this,
				dataType: 'html'
			},
			maxWidth: 500,
			maxHeight: 700,
			onContentSet: function(ev) {
				var contentEl = ev.contentEl;
				var overlay = ev.overlay;
				$('button.approve-trigger', contentEl).on('click', function(ev) {
					ev.preventDefault();
					self.approveEdit($('input.article_id', contentEl).val());
					overlay.closeOverlay();
				});
				$('button.disapprove-trigger', contentEl).on('click', function(ev) {
					ev.preventDefault();
					self.disapproveEdit($('input.article_id', contentEl).val());
					overlay.closeOverlay();
				});
			}
		});
		overlay.openOverlay();
	},

	approveEdit: function(article_id) {
		$.ajax({
			url: BASE_URL + 'agent/kb/validating-articles/validate/'+article_id+'.json',
			type: 'POST',
			context: this,
			dataType: 'json',
			success: function(info) {
				var article_id = info.article_id;
				$('.article-' + article_id, this.wrapper).remove();

				this.removeFromList(article_id, info.type);
			}
		});
	},

	disapproveEdit: function(article_id) {
		$.ajax({
			url: BASE_URL + 'agent/kb/validating-articles/disapprove/'+article_id+'.json',
			type: 'POST',
			context: this,
			dataType: 'json',
			success: function(info) {
				var article_id = info.article_id;
				$('.article-' + article_id, this.wrapper).remove();

				this.removeFromList(article_id, info.type);
			}
		});
	},

	removeFromList: function(article_id, type) {
		var count_total = $('.counter-total', this.wrapper);
		var count_type = $('.counter-' + type, this.wrapper);

		var total_int = parseInt(count_total.html());
		var type_int = parseInt(count_total.html());

		count_total.html(total_int - 1);
		count_type.html(type_int - 1);

		var wrap_type = $('.wrap-' + type, this.wrapper);
		if (!$('tr.article', wrap_type).length) {
			wrap_type.remove();
		}
	},

	loadPreviewArticle: function(url) {

		var self = this;

		var overlay = new DeskPRO.UI.Overlay({
			destroyOnClose: true,
			contentMethod: 'ajax',
			contentAjax: {
				url: url,
				type: 'GET',
				context: this,
				dataType: 'html'
			},
			maxWidth: 500,
			maxHeight: 700,
			onContentSet: function(ev) {
				var contentEl = ev.contentEl;
				var overlay = ev.overlay;
				$('button.approve-trigger', contentEl).on('click', function(ev) {
					ev.preventDefault();
					self.approveEdit($('input.article_id', contentEl).val());
					overlay.closeOverlay();
				});
				$('button.disapprove-trigger', contentEl).on('click', function(ev) {
					ev.preventDefault();
					self.disapproveEdit($('input.article_id', contentEl).val());
					overlay.closeOverlay();
				});
			}
		});
		overlay.openOverlay();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.KbList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'kb-filter',
			resultId: this.meta.resultId,
			refreshUrl: this.meta.refreshUrl,
			prefSaveResultId: '0'
		});
		this.ownObject(this.displayOptions);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onCountChange: function(count) {
				var isOpen = self.massActions.isOpen();

				if (count > 0 && !isOpen) {
					self.massActions.open();
				} else if (count <= 0 && isOpen) {
					self.massActions.close();
				}
			}
		});
		this.ownObject(this.selectionBar);

		this.listWrapper = $('section.kb-simple-list', this.wrapper);

		DeskPRO_Window.getTabWatcher().addTabTypeWatcher('ticket', this);
		this.addEvent('watchedTabActivated', function(tab) {
			if (DeskPRO_Window.getTabWatcher().getTabType(tab) == 'ticket') {
				self.initVisibleTicket();
			}
		});
		this.addEvent('watchedTabDeactivated', function(tab) {
			if (DeskPRO_Window.getTabWatcher().getTabType(tab) == 'ticket') {
				self.removeVisibleTicket();
			}
		});

		// Or if we're already viewing a tab ticket...c
		if (DeskPRO_Window.getTabWatcher().isTabTypeActive('ticket')) {
			self.initVisibleTicket();
		}

		$('section.kb-simple-list', this.wrapper)
			.on('click', '.kb-insert-link', function(ev) { ev.stopPropagation(); self.insertIntoTicket($(this).data('article-id'), 'link') })
			.on('click', '.kb-insert-content', function(ev) { ev.stopPropagation(); self.insertIntoTicket($(this).data('article-id'), 'content') })

		this.relatedContentList = new DeskPRO.Agent.PageHelper.RelatedContentList(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.relatedContentList);

		this.sendContentLink = new DeskPRO.Agent.PageHelper.SendContentLink(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.sendContentLink);

		// Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);

		this.enableHighlightOpenRows('article', 'article_id', 'article.article-');

		this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);

		this.massActions = new DeskPRO.Agent.PageHelper.MassActions(this, {
			isListView: false,
			applyAction: (this.massApplyAction).bind(this)
		});

		DeskPRO.ElementHandler_Exec($('#kb-mass-action-overlay'));

		// Cat editor
		this._initCatEditor();
	},

	massApplyAction: function(wrapper, formData) {
		var data = formData,
			myFormData = $('input, select',wrapper).serializeArray();

		$(myFormData).each(function(index, param) {
			data[param.name] = param.value;
		});

		$.ajax({
			type: 'POST',
			url: BASE_URL + "agent/kb/article/ajax-mass-save",
			'data': data,
			'dataType': 'json',
			success: (this.actionAppliedCallback).bind(this)
		});
	},

	actionAppliedCallback: function(data) {
		if(data && data.success) {
			var category = data.category;

			var section = DeskPRO_Window.sections.publish_section;
			DeskPRO_Window.getSectionData('publish_section', function(data) {
				(section._initSection.bind(section))(data);
				$('#publish_outline_articlescat_list .kb-cat-' + category + ' .is-nav-item').click();
			});
		}

		if(data.error) {
			DeskPRO_Window.showAlert(data.error);
		}
	},

	initVisibleTicket: function() {
		this.listWrapper.addClass('with-visible-ticket');
	},

	removeVisibleTicket: function() {
		this.listWrapper.removeClass('with-visible-ticket');
	},

	insertIntoTicket: function(article_id, action) {

		var ticketTab = DeskPRO_Window.getTabWatcher().getActiveTabIfType('ticket');
		if (!ticketTab) {
			return;
		}

		var ticketPage = ticketTab.page;

		$.ajax({
			url: BASE_URL + 'agent/kb/article/'+article_id+'/info',
			type: 'GET',
			dataType: 'json',
			success: function(data) {
				if (action == 'content') {
					ticketPage.appendToMessage(data.content, true);
				} else {
					ticketPage.appendToMessage(data.permalink);
				}
			}
		});
	},

	_initCatEditor: function() {
		var self = this;
		var catEl = this.getEl('tab_cat');
		if (!catEl[0]) {
			return;
		}

		var tree = this.getEl('cattree');
		var treeData = tree.data('treedata');
		var treeSave = this.getEl('cattree_struct');
		tree.tree({
			data: treeData,
			dragAndDrop: true
		});
		tree.bind('tree.move', function(event) {
			event.move_info.do_move();
			treeSave.val(tree.tree('toJson'));
		});

		this.getEl('catfoot').find('.cat-save-trigger').on('click', function(ev){
			Orb.cancelEvent(ev);

			var postData = catEl.find('input').serializeArray();

			self.getEl('catfoot').addClass('dp-loading-on');
			$.ajax({
				url: $(this).data('save-url'),
				data: postData,
				type: 'POST',
				dataType: 'json',
				complete: function() {
					self.getEl('catfoot').removeClass('dp-loading-on');
				},
				success: function() {
					DeskPRO_Window.sections.publish_section.reload();
				}
			});
		});

		var delCat = this.getEl('del_cat');
		delCat.find('.cat-del-trigger').on('click', function(ev) {
			Orb.cancelEvent(ev);
			delCat.addClass('dp-loading-on');

			$.ajax({
				url: $(this).data('save-url'),
				type: 'POST',
				dataType: 'json',
				complete: function() {
					delCat.removeClass('dp-loading-on');
				},
				success: function(ret) {
					if (ret.error_code && ret.error_code == 'not_empty') {
						DeskPRO_Window.showAlert('The category could not be deleted because it is not empty.');
						return;
					}

					DeskPRO_Window.sections.publish_section.reload();
					DeskPRO_Window.runPageRoute('listpane:' + BASE_URL + 'agent/kb/list/0');
				}
			});
		});

		allUg = catEl.find('.ug-check');
		ugEveryone = allUg.filter('.ug-1');
		ugOther    = allUg.not('.ug-1');

		var updateChecks = function(checked) {
			if (checked) {
				ugOther.prop('checked', true);
				ugOther.prop('disabled', true);
			} else {
				ugOther.prop('disabled', false);
			}
		};

		ugEveryone.on('click', function() {
			updateChecks(this.checked);
		});
		updateChecks(ugEveryone.prop('checked'));
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.AgentChatHistory = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
		this.contentWrapper = null;
	},

	initPage: function(el) {

		DeskPRO_Window.getMessageBroker().sendMessage('agentchat-section.list-activated', { id: this.meta.agentId });

		this.wrapper = $(el);
		this.contentWrapper = $('div.content:first', this.wrapper);

		this.enableHighlightOpenRows('agentchat', 'conversation_id', '.row-item.convo-');

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.AgentTeamChatHistory = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
		this.contentWrapper = null;
	},

	initPage: function(el) {

		DeskPRO_Window.getMessageBroker().sendMessage('agentchat-section.team-list-activated', { id: this.meta.agentTeamId });

		this.wrapper = $(el);
		this.contentWrapper = $('div.content:first', this.wrapper);

		this.enableHighlightOpenRows('agentchat', 'conversation_id', '.row-item.convo-');

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.OpenChats = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,


	initPage: function(el) {
		var self = this;
		this.el = el;

		var agentId = this.meta.agent_id;

		var removeConvo = function(convoId) {
			var row = $('article.convo-' + convoId);
			row.slideUp('fast', function() {
				row.remove();
			});
		};
		var addConvo = function(convoId) {
			// TODO later prepend the row like in tickets,
			// for now this is easiest
			DeskPRO_Window.loadRoute(self.meta.routeData);
		};

		DeskPRO_Window.getMessageBroker().addMessageListener('chat.new', function(data) {
			if (data.agent_id && data.agent_id == agentId) {
				addConvo(data.conversation_id);
			}
		}, this);
		DeskPRO_Window.getMessageBroker().addMessageListener('chat.reassigned', function(data) {
			if (data.old_agent_id && data.old_agent_id == agentId) {
				removeConvo(data.conversation_id);
			} else if (data.agent_id && data.agent_id == agentId) {
				addConvo(data.conversation_id);
			}
		}, this);
		DeskPRO_Window.getMessageBroker().addMessageListener('chat.unassigned', function(data) {
			if (data.old_agent_id && data.old_agent_id == agentId) {
				removeConvo(data.conversation_id);
			}
		}, this);
		DeskPRO_Window.getMessageBroker().addMessageListener('chat.ended', function(data) {
			if (data.agent_id && data.agent_id == agentId) {
				removeConvo(data.conversation_id);
			}
		}, this);

		this.enableHighlightOpenRows('userchat', 'conversation_id', '.row-item.convo-');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.UserChatFilter = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'chat-list';
		this.wrapper = null;
		this.contentWrapper = null;
		this.overlay = null;
		this.appendUrl = null;
		this.actionsBarHelper = null;
		this.resultTypeName = 'filter';
		this.resultTypeId = 0;
	},

	initPage: function(el) {
		var self = this;
		this.el = el;

		this.enableHighlightOpenRows('userchat', 'conversation_id', '.row-item.convo-');

		this.wrapper = $(el);
		this.contentWrapper = $('div.content:first', this.wrapper);

		this.resultTypeId = this.meta.cache_id || 0;

		if (this.getMetaData('noResults')) {
			this.noMoreResults = true;
			$('.no-more-results', this.contentWrapper).show();
		}

		var opt = {
			resultIds: this.meta.resultIds,
			perPage: this.meta.perPage || 50
		};
		if (this.meta.viewType && this.meta.viewType == 'list') {
			opt.resultRowSelector = 'tr.row-item';
			opt.resultsContainer = $('.table-result-list table', el);
			opt.navEl = $('.bottom-action-bar', el);
		}

		this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.FeedbackFilter = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
		this.filterSearchForm = null;
	},

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'feedback-filter',
			resultId: this.meta.resultId,
			refreshUrl: this.meta.refreshUrl,
			prefSaveResultId: '0'
		});
		this.ownObject(this.displayOptions);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			/*onCountChange: function(count) {
				var isOpen = self.massActionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.massActionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.massActionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		// Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);

		this.listWrapper = $('section.feedback-simple-list', this.wrapper);

		this.relatedContentList = new DeskPRO.Agent.PageHelper.RelatedContentList(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.relatedContentList);

		this.massActionsMenu = new DeskPRO.UI.Menu({
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			menuElement: $('.actions-menu:first', this.wrapper),
			onItemClicked: function(info) {
				var itemEl = $(info.itemEl);
				var menuEl = itemEl.parent();
				var menuType = menuEl.data('menu-type');

				var postData = self.selectionBar.getCheckedFormValues('ids[]');
				var removeFromList = false;
				var action = '';

				switch (menuType) {
					case 'feedback-status-menu':

						action = 'set-status';

						postData.push({
							name: 'status',
							value: itemEl.data('option-value')
						});
						break;

					case 'feedback-category-menu':

						action = 'set-category';

						postData.push({
							name: 'category_id',
							value: itemEl.data('category-id')
						});

						break;

					case 'feedback-massactions-menu':

						switch (itemEl.data('action')) {
							case 'delete':
								action = 'set-status';
								postData.push({
									name: 'status',
									value: 'hidden.deleted'
								});

								removeFromList = true;

								break;

							case 'spam':
								action = 'set-status';
								postData.push({
									name: 'status',
									value: 'hidden.spam'
								});

								removeFromList = true;

								break;
						}

						break;

					default:
						return;
						break;
				}

				$.ajax({
					url: BASE_URL + 'agent/feedback/filter/mass-actions/' + action,
					data: postData,
					type: 'POST',
					dataType: 'json',
					success: function(data) {
						if (removeFromList) {
							self.selectionBar.getChecked().parent().fadeOut('fast');
						}

						self.selectionBar.checkNone();

						DeskPRO_Window.runPageRoute('listpane:' + self.meta.routeUrl);
						DeskPRO_Window.sections.feedback_section.reload();
					}
				});
			}
		});
		this.ownObject(this.massActionsMenu);

		var opt = {
			resultIds: this.meta.resultIds,
			perPage: this.meta.perPage || 50,
			refreshMode: true,
			currentPage: this.meta.currentPage
		};
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);

		this.enableHighlightOpenRows('feedback', 'feedback_id', 'article.feedback-');

		this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.NewCustomFilter = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
		this.filterSearchForm = null;
	},

	initPage: function(el) {
		this.wrapper = el;

		this.topSection = $('.list-top-area', this.wrapper);

		var criteriaList  = $('.search-form', this.topSection);
		var criteriaTerms = $('.search-builder-tpl', this.topSection);

		var editor = new DeskPRO.Form.RuleBuilder(criteriaTerms);
		$('.add-term', criteriaList).data('add-count', 0).on('click', function() {
			var count = parseInt($(this).data('add-count'));
			var basename = 'terms['+count+']';

			$(this).data('add-count', count+1);

			editor.addNewRow($('.search-terms', criteriaList), basename);
		});

		var searchDataEl = $('.search-form-data:first', this.topSection);
		if (searchDataEl.length) {
			var searchData = searchDataEl.get(0).innerHTML;
			searchData = $.parseJSON(searchData);

			if (searchData.terms) {
				Array.each(searchData.terms, function(info, x) {
					var basename = 'terms[initial_' + x + ']';
					editor.addNewRow($('.search-terms', criteriaList), basename, {
						type: info.type,
						op: info.op,
						options: info.options
					});
				});
			}

			if (searchData.order_by) {
				$('[name="order_by"]', this.topSection).val(searchData.order_by);
			}

			searchDataEl.remove();
		}

		var form = $('form.ticket-search-form', this.topSection);
		form.on('submit', function(ev) {
			ev.preventDefault();

			var url = form.attr('action');
			var data = form.serializeArray();

			DeskPRO_Window.loadListPane(url, { postData: data });
		});
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.NewsList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.wrapper = null;
	},

	initPage: function(el) {
		this.wrapper = el;

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'news-filter',
			resultId: this.meta.resultId,
			refreshUrl: this.meta.refreshUrl,
			prefSaveResultId: '0'
		});
		this.ownObject(this.displayOptions);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {

		});
		this.ownObject(this.selectionBar);

		this.listWrapper = $('section.news-simple-list', this.wrapper);

		this.relatedContentList = new DeskPRO.Agent.PageHelper.RelatedContentList(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.relatedContentList);

		this.enableHighlightOpenRows('news', 'news_id', 'article.news-');

		this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);

		// Cat editor
		this._initCatEditor();
	},

	_initCatEditor: function() {
		var self = this;
		var catEl = this.getEl('tab_cat');
		if (!catEl[0]) {
			return;
		}

		var tree = this.getEl('cattree');
		var treeData = tree.data('treedata');
		var treeSave = this.getEl('cattree_struct');
		tree.tree({
			data: treeData,
			dragAndDrop: true
		});
		tree.bind('tree.move', function(event) {
			event.move_info.do_move();
			treeSave.val(tree.tree('toJson'));
		});

		this.getEl('catfoot').find('.cat-save-trigger').on('click', function(ev){
			Orb.cancelEvent(ev);

			var postData = catEl.find('input').serializeArray();

			self.getEl('catfoot').addClass('dp-loading-on');
			$.ajax({
				url: $(this).data('save-url'),
				data: postData,
				type: 'POST',
				dataType: 'json',
				complete: function() {
					self.getEl('catfoot').removeClass('dp-loading-on');
				},
				success: function() {
					DeskPRO_Window.sections.publish_section.reload();
				}
			});
		});

		var delCat = this.getEl('del_cat');
		delCat.find('.cat-del-trigger').on('click', function(ev) {
			Orb.cancelEvent(ev);
			delCat.addClass('dp-loading-on');

			$.ajax({
				url: $(this).data('save-url'),
				type: 'POST',
				dataType: 'json',
				complete: function() {
					delCat.removeClass('dp-loading-on');
				},
				success: function(ret) {
					if (ret.error_code && ret.error_code == 'not_empty') {
						DeskPRO_Window.showAlert('The category could not be deleted because it is not empty.');
						return;
					}

					DeskPRO_Window.sections.publish_section.reload();
					DeskPRO_Window.runPageRoute('listpane:' + BASE_URL + 'agent/kb/list/0');
				}
			});
		});

		allUg = catEl.find('.ug-check');
		ugEveryone = allUg.filter('.ug-1');
		ugOther    = allUg.not('.ug-1');

		var updateChecks = function(checked) {
			if (checked) {
				ugOther.prop('checked', true);
				ugOther.prop('disabled', true);
			} else {
				ugOther.prop('disabled', false);
			}
		};

		ugEveryone.on('click', function() {
			updateChecks(this.checked);
		});
		updateChecks(ugEveryone.prop('checked'));
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.DownloadList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'download-filter',
			resultId: this.meta.resultId,
			refreshUrl: this.meta.refreshUrl,
			prefSaveResultId: '0'
		});
		this.ownObject(this.displayOptions);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {});
		this.ownObject(this.selectionBar);

		this.listWrapper = $('section.downloads-simple-list', this.wrapper)
			.on('click', '.dl-insert-link', function() { self.insertIntoTicket($(this).data('download-id'), 'link') })
			.on('click', '.dl-insert-attach', function() { self.insertIntoTicket($(this).data('download-id'), 'attach') });

		DeskPRO_Window.getTabWatcher().addTabTypeWatcher('ticket', this);
		this.addEvent('watchedTabActivated', function(tab) {
			if (DeskPRO_Window.getTabWatcher().getTabType(tab) == 'ticket') {
				self.initVisibleTicket();
			}
		});
		this.addEvent('watchedTabDeactivated', function(tab) {
			if (DeskPRO_Window.getTabWatcher().getTabType(tab) == 'ticket') {
				self.removeVisibleTicket();
			}
		});

		// Or if we're already viewing a tab ticket...
		if (DeskPRO_Window.getTabWatcher().isTabTypeActive('ticket')) {
			self.initVisibleTicket();
		}

		this.relatedContentList = new DeskPRO.Agent.PageHelper.RelatedContentList(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.relatedContentList);

		// Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var disOptWrap = self.displayOptions.getWrapperElement();
				var sel = $('select.sel-order-by', disOptWrap);
				$('option', sel).prop('selected', false);
				$('option.' + prop, sel).prop('selected', true);

				self.displayOptions.saveAndRefresh();
			}
		});
		this.ownObject(this.sortingMenu);

		this.enableHighlightOpenRows('download', 'download_id', 'article.download-');
		this.listNav = new DeskPRO.Agent.PageHelper.ListNav(this);

		// Cat editor
		this._initCatEditor();
	},

	initVisibleTicket: function() {
		this.listWrapper.addClass('with-visible-ticket');
	},

	removeVisibleTicket: function() {
		this.listWrapper.removeClass('with-visible-ticket');
	},

	insertIntoTicket: function(download_id, action) {

		var ticketTab = DeskPRO_Window.getTabWatcher().getActiveTabIfType('ticket');
		if (!ticketTab) {
			return;
		}

		var ticketPage = ticketTab.page;

		$.ajax({
			url: BASE_URL + 'agent/downloads/file/'+download_id+'/info',
			type: 'GET',
			dataType: 'json',
			success: function(data) {
				if (action == 'attach') {
					ticketPage.addAttachToList(data);
				} else {
					ticketPage.appendToMessage(data.permalink);
				}
			}
		});
	},

	_initCatEditor: function() {
		var self = this;
		var catEl = this.getEl('tab_cat');
		if (!catEl[0]) {
			return;
		}

		var tree = this.getEl('cattree');
		var treeData = tree.data('treedata');
		var treeSave = this.getEl('cattree_struct');
		tree.tree({
			data: treeData,
			dragAndDrop: true
		});
		tree.bind('tree.move', function(event) {
			event.move_info.do_move();
			treeSave.val(tree.tree('toJson'));
		});

		this.getEl('catfoot').find('.cat-save-trigger').on('click', function(ev){
			Orb.cancelEvent(ev);

			var postData = catEl.find('input').serializeArray();

			self.getEl('catfoot').addClass('dp-loading-on');
			$.ajax({
				url: $(this).data('save-url'),
				data: postData,
				type: 'POST',
				dataType: 'json',
				complete: function() {
					self.getEl('catfoot').removeClass('dp-loading-on');
				},
				success: function() {
					DeskPRO_Window.sections.publish_section.reload();
				}
			});
		});

		var delCat = this.getEl('del_cat');
		delCat.find('.cat-del-trigger').on('click', function(ev) {
			Orb.cancelEvent(ev);
			delCat.addClass('dp-loading-on');

			$.ajax({
				url: $(this).data('save-url'),
				type: 'POST',
				dataType: 'json',
				complete: function() {
					delCat.removeClass('dp-loading-on');
				},
				success: function(ret) {
					if (ret.error_code && ret.error_code == 'not_empty') {
						DeskPRO_Window.showAlert('The category could not be deleted because it is not empty.');
						return;
					}

					DeskPRO_Window.sections.publish_section.reload();
					DeskPRO_Window.runPageRoute('listpane:' + BASE_URL + 'agent/downloads/list/0');
				}
			});
		});

		allUg = catEl.find('.ug-check');
		ugEveryone = allUg.filter('.ug-1');
		ugOther    = allUg.not('.ug-1');

		var updateChecks = function(checked) {
			if (checked) {
				ugOther.prop('checked', true);
				ugOther.prop('disabled', true);
			} else {
				ugOther.prop('disabled', false);
			}
		};

		ugEveryone.on('click', function() {
			updateChecks(this.checked);
		});
		updateChecks(ugEveryone.prop('checked'));
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishListComments = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		var btn  = this.wrapper.find('.list-selection-bar .perform-actions-trigger');
		var load = this.wrapper.find('.list-selection-bar .ajax-loading');

		this.actionsMenu = new DeskPRO.UI.Menu({
			menuElement: $('ul.actions-menu:first', this.wrapper),
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			onItemClicked: function(info) {
				var data = [];
				var lines = [];
				$('input.item-select:checked', this.wrapper).each(function() {
					lines.push($(this).parent().get(0));
					var typename = $(this).data('content-type');
					var id = $(this).data('comment-id');

					data.push({
						name: 'content[' + typename + '][]',
						value: id
					});
				});

				if (!data.length) {
					return;
				}

				btn.hide();
				load.show();

				var action = $(info.itemEl).data('action');

				$.ajax({
					url: BASE_URL + 'agent/publish/comments/validating-mass-actions/' + action,
					data: data,
					type: 'POST',
					dataType: 'json',
					complete: function() {
						load.hide();
						btn.show();
					},
					success: function() {
						// Reload self
						DeskPRO_Window.runPageRoute('listpane:' + BASE_URL + 'agent/publish/comments/list/' + self.meta.viewType)

						if (DeskPRO_Window.sections.publish_section) {
							DeskPRO_Window.sections.publish_section.reload();
						}
					}
				});
			}
		});
		this.ownObject(this.actionsMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function(ev) {
				self.actionsMenu.open(ev);
			}/*,
			onCountChange: function(count) {
				var isOpen = self.actionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.actionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.actionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		var findRowInfo = function(el) {

			var row = $(el);

			var editRow = $(el).closest('div.edit-comment');
			if (editRow.length) {
				var row = $('article.' + editRow.data('content-type') + '-' + editRow.data('comment-id'));
				return findRowInfo(row);
			}

			row = row.closest('article');

			var check = $('input.item-select', row);
			if (!check.length) {
				return;
			}

			var info = {
				row: row,
				contentType: $(check).data('content-type'),
				commentId: $(check).data('comment-id')
			};

			var editRow = $('div.edit-' + info.contentType + '-' + info.commentId, self.wrapper);
			DP.console.log(editRow);
			info.editRow = editRow;

			return info;
		};

		this.wrapper.on('click', '.validate-approve', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.approveComment(info.contentType, info.commentId, info.row);
		});
		this.wrapper.on('click', '.validate-delete', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.deleteComment(info.contentType, info.commentId, info.row);
		});

		this.wrapper.on('click', '.validate-edit', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.editComment(info.contentType, info.commentId, info.row, info);
		});

		this.wrapper.on('click', '.comment-editsave-trigger', function(ev) {
			var info = findRowInfo(this);

			var commentText = $('textarea', info.editRow).val().trim();
			if (!commentText.length) {
				info.row.show();
				info.editRow.hide();
			}

			$.ajax({
				url: BASE_URL + 'agent/publish/comments/save-comment/'+info.contentType+'/'+info.commentId,
				type: 'POST',
				data: {
					comment: commentText
				},
				dataType: 'json',
				success: function(data) {
					var rendered = $('.rendered', info.row);
					rendered.html(data.comment_html);

					info.row.show();
					info.editRow.hide();
				}
			});
		});

		this.wrapper.on('click', '.comment-editcancel-trigger', function(ev) {
			var info = findRowInfo(this);
			var editEl = info.editRow;

			info.row.show();
			editEl.hide();
		});

		this.wrapper.on('click', '.validate-create-ticket', function(ev) {
			var info = findRowInfo(this);
			$.ajax({
				url: BASE_URL + 'agent/publish/comments/new-ticket-info/' + info.contentType + '/' + info.commentId + '.json',
				type: 'GET',
				dataType: 'json',
				success: function(data) {
					DeskPRO_Window.newTicketLoader.open(function(page) {
						page.setNewByComment(data);
					});
				}
			});
		});

		DeskPRO_Window.getMessageBroker().addMessageListener('agent-ui.comment-remove', function(data) {
			$('article.' + data.comment_type + '-' + data.comment_id, this.wrapper).fadeOut();
		});
	},

	deleteComment: function(typename, commentId, el) {
		if (!el) {
			el = $('article.' + typename + '-' + commentId, this.wrapper);
		}
		el.fadeOut();

		this.updateCount('sub');

		$.ajax({
			url: BASE_URL + 'agent/publish/comments/delete/'+typename+'/'+commentId,
			type: 'POST',
			context: this,
			dataType: 'json',
			error: function() {
				this.updateCount('add');
				el.fadeIn();
			},
			success: function(data) {
				el.remove();

				if (DeskPRO_Window.sections.publish_section) {
					DeskPRO_Window.sections.publish_section.modCommentCount(typename, '-');
				}
			}
		});
	},

	approveComment: function(typename, commentId, el) {
		if (!el) {
			el = $('article.' + typename + '-' + commentId, this.wrapper);
		}

		el.fadeOut();

		this.updateCount('sub');

		$.ajax({
			url: BASE_URL + 'agent/publish/comments/approve/'+typename+'/'+commentId,
			type: 'POST',
			context: this,
			dataType: 'json',
			error: function() {
				this.updateCount('add');
				if (el) {
					el.fadeIn();
				}
			},
			success: function(data) {
				if (el) {
					el.remove();
				}
			}
		});
	},

	editComment: function(typename, commentId, el, info) {

		el.hide();
		var editEl = info.editRow;

		editEl.show();
	},

	updateCount: function(action, num) {
		var countEl = $('#publish_validating_comments_count');
		var count = parseInt(countEl.text());

		num = num || 1;

		if (action == 'add') {
			count += num;
		} else {
			count -= num;
		}

		if (count < 0) {
			count = 0;
		}

		var countEl = $('#publish_validating_comments_count').text(count);

		DeskPRO_Window.sections.publish_section.recountBadge();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishValidatingComments = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		var btn  = this.wrapper.find('.list-selection-bar .perform-actions-trigger');
		var load = this.wrapper.find('.list-selection-bar .ajax-loading');

		this.actionsMenu = new DeskPRO.UI.Menu({
			menuElement: $('ul.actions-menu:first', this.wrapper),
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			onItemClicked: function(info) {
				var data = [];
				var lines = [];
				$('input.item-select:checked', this.wrapper).each(function() {
					lines.push($(this).parent().get(0));
					var typename = $(this).data('content-type');
					var id = $(this).data('comment-id');

					data.push({
						name: 'content[' + typename + '][]',
						value: id
					});
				});

				if (!data.length) {
					return;
				}

				btn.hide();
				load.show();

				var action = $(info.itemEl).data('action');

				$.ajax({
					url: BASE_URL + 'agent/publish/comments/validating-mass-actions/' + action,
					data: data,
					type: 'POST',
					dataType: 'json',
					complete: function() {
						load.hide();
						btn.show();
					},
					success: function() {
						self.selectionBar.checkNone();
						self.updateCount('sub', lines.length);
						$(lines).fadeOut();
					}
				});
			}
		});
		this.ownObject(this.actionsMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function(ev) {
				self.actionsMenu.open(ev);
			}/*,
			onCountChange: function(count) {
				var isOpen = self.actionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.actionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.actionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		var findRowInfo = function(el) {

			var row = $(el);

			var editRow = $(el).closest('div.edit-comment');
			if (editRow.length) {
				var row = $('article.' + editRow.data('content-type') + '-' + editRow.data('comment-id'));
				return findRowInfo(row);
			}

			row = row.closest('article');

			var check = $('input.item-select', row);
			if (!check.length) {
				return;
			}

			var info = {
				row: row,
				contentType: $(check).data('content-type'),
				commentId: $(check).data('comment-id')
			};

			var editRow = $('div.edit-' + info.contentType + '-' + info.commentId, self.wrapper);
			DP.console.log(editRow);
			info.editRow = editRow;

			return info;
		};

		this.wrapper.on('click', '.validate-approve', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.approveComment(info.contentType, info.commentId, info.row);
		});
		this.wrapper.on('click', '.validate-delete', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.deleteComment(info.contentType, info.commentId, info.row);
		});

		this.wrapper.on('click', '.validate-edit', function(ev) {
			ev.stopPropagation();

			var info = findRowInfo(this);
			self.editComment(info.contentType, info.commentId, info.row, info);
		});

		this.wrapper.on('click', '.comment-editsave-trigger', function(ev) {
			var info = findRowInfo(this);

			var commentText = $('textarea', info.editRow).val().trim();
			if (!commentText.length) {
				info.row.show();
				info.editRow.hide();
			}

			$.ajax({
				url: BASE_URL + 'agent/publish/comments/save-comment/'+info.contentType+'/'+info.commentId,
				type: 'POST',
				data: {
					comment: commentText
				},
				dataType: 'json',
				success: function(data) {
					var rendered = $('.rendered', info.row);
					rendered.html(data.comment_html);

					info.row.show();
					info.editRow.hide();
				}
			});
		});

		this.wrapper.on('click', '.comment-editcancel-trigger', function(ev) {
			var info = findRowInfo(this);
			var editEl = info.editRow;

			info.row.show();
			editEl.hide();
		});

		this.wrapper.on('click', '.validate-create-ticket', function(ev) {
			var info = findRowInfo(this);
			$.ajax({
				url: BASE_URL + 'agent/publish/comments/new-ticket-info/' + info.contentType + '/' + info.commentId + '.json',
				type: 'GET',
				dataType: 'json',
				success: function(data) {
					DeskPRO_Window.newTicketLoader.open(function(page) {
						page.setNewByComment(data);
					});
				}
			});
		});

		DeskPRO_Window.getMessageBroker().addMessageListener('agent-ui.comment-remove', function(data) {
			$('article.' + data.comment_type + '-' + data.comment_id, this.wrapper).fadeOut();
		});
	},

	deleteComment: function(typename, commentId, el) {
		if (!el) {
			el = $('article.' + typename + '-' + commentId, this.wrapper);
		}
		el.fadeOut();

		this.updateCount('sub');

		$.ajax({
			url: BASE_URL + 'agent/publish/comments/delete/'+typename+'/'+commentId,
			type: 'POST',
			context: this,
			dataType: 'json',
			error: function() {
				this.updateCount('add');
				el.fadeIn();
			},
			success: function(data) {
				el.remove();

				if (DeskPRO_Window.sections.publish_section) {
					DeskPRO_Window.sections.publish_section.modCommentCount(typename, '-');
				}
			}
		});
	},

	approveComment: function(typename, commentId, el) {
		if (!el) {
			el = $('article.' + typename + '-' + commentId, this.wrapper);
		}

		el.fadeOut();

		this.updateCount('sub');

		$.ajax({
			url: BASE_URL + 'agent/publish/comments/approve/'+typename+'/'+commentId,
			type: 'POST',
			context: this,
			dataType: 'json',
			error: function() {
				this.updateCount('add');
				if (el) {
					el.fadeIn();
				}
			},
			success: function(data) {
				if (el) {
					el.remove();
				}
			}
		});
	},

	editComment: function(typename, commentId, el, info) {

		el.hide();
		var editEl = info.editRow;

		editEl.show();
	},

	updateCount: function(action, num) {
		var countEl = $('#publish_validating_comments_count');
		var count = parseInt(countEl.text());

		num = num || 1;

		if (action == 'add') {
			count += num;
		} else {
			count -= num;
		}

		if (count < 0) {
			count = 0;
		}

		var countEl = $('#publish_validating_comments_count').text(count);

		DeskPRO_Window.sections.publish_section.recountBadge();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishValidatingContent = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		DeskPRO_Window.getMessageBroker().addMessageListener('publish.validating.list-remove', function (info) {
			var el = $('article.' + info.typename + '-' + info.contentId).slideUp();
			self.listRemove(el);
		});

		var btn  = this.wrapper.find('.list-selection-bar .perform-actions-trigger');
		var load = this.wrapper.find('.list-selection-bar .ajax-loading');

		this.actionsMenu = new DeskPRO.UI.Menu({
			menuElement: $('ul.actions-menu:first', this.wrapper),
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			onItemClicked: function(info) {
				var data = [];
				var lines = [];
				$('input.item-select:checked', this.wrapper).each(function() {
					lines.push($(this).parent().get(0));
					var typename = $(this).data('content-type');
					var id = $(this).data('content-id');

					data.push({
						name: 'content[' + typename + '][]',
						value: id
					});
				});

				if (!data.length) {
					return;
				}

				var action = $(info.itemEl).data('action');

				btn.hide();
				load.show();

				var sendFn = function() {
					$.ajax({
						url: BASE_URL + 'agent/publish/content/validating-mass-actions/' + action,
						data: data,
						type: 'POST',
						dataType: 'json',
						complete: function() {
							load.hide();
							btn.show();
						},
						success: function() {
							$(lines).fadeOut().each(function() {
								self.listRemove($(this));
							});
						}
					});
				}

				if (action == 'disapprove') {
					DeskPRO_Window.showPrompt("Enter a reason or comment to send to the authors", function(reason) {
						data.push({
							name: 'reason',
							value: reason
						});
						sendFn();
					});
				} else {
					sendFn();
				}
			}
		});
		this.ownObject(this.actionsMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function(ev) {
				self.actionsMenu.open(ev);
			}/*,
			onCountChange: function(count) {
				var isOpen = self.actionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.actionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.actionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);

		this.enableHighlightOpenRows('feedback', 'feedback_id', '.row-item.feedback-');
	},

	listRemove: function(el) {
		DeskPRO_Window.util.modCountEl($('#publish_validating_count'), '-');
		DeskPRO_Window.sections.publish_section.recountBadge();
		this.selectionBar.checkNone();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishDraftsList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		DeskPRO_Window.getMessageBroker().addMessageListener('publish.drafts.list-remove', function (info) {
			$('article.' + info.typename + '-' + info.contentId, this.wrapper).slideUp();
		}, this);

		this.actionsMenu = new DeskPRO.UI.Menu({
			triggerElement: $('.perform-actions-trigger:first', this.wrapper),
			menuElement: $('ul.actions-menu:first', this.wrapper),
			onItemClicked: function(info) {
				var data = [];
				var lines = [];
				$('input.item-select:checked', this.wrapper).each(function() {
					lines.push($(this).parent().get(0));
					var typename = $(this).data('content-type');
					var id = $(this).data('content-id');

					if (typename && id) {
						data.push({
							name: 'content[' + typename + '][]',
							value: id
						});
					}
				});

				if (!data.length) {
					return;
				}

				var action = $(info.itemEl).data('action');

				$.ajax({
					url: BASE_URL + 'agent/publish/drafts/mass-actions/' + action,
					data: data,
					type: 'POST',
					dataType: 'json',
					context: this,
					success: function(data) {
						self.selectionBar.checkNone();
						if (data.affected) {
							Array.each(data.affected, function(info) {
								DeskPRO_Window.getMessageBroker().sendMessage('publish.drafts.list-remove', info);
							}, this);
						}
					}
				});
			}
		});
		this.ownObject(this.actionsMenu);

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function(ev) {
				self.actionsMenu.open(ev);
			}/*,
			onCountChange: function(count) {
				var isOpen = self.actionsMenu.isOpen();

				if (count > 0 && !isOpen) {
					self.actionsMenu.open();
				} else if (count <= 0 && isOpen) {
					self.actionsMenu.close();
				}
			}*/
		});
		this.ownObject(this.selectionBar);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishSearch = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;

		this.listWrapper = $('section.list-listing', this.wrapper);
		this.sendContentLink = new DeskPRO.Agent.PageHelper.SendContentLink(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.sendContentLink);
	}
});
Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.FeedbackSearch = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initPage: function(el) {
		var self = this;
		this.wrapper = el;
	}
});
Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.PublishSearchLog = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'publish_searchlog';
	},

	initPage: function(el) {
		this.tabs = new DeskPRO.UI.SimpleTabs({
			triggerElements: $('li', this.getEl('tabs'))
		});
		this.ownObject(this.tabs);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.FeedbackCommentsValidating = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.PublishValidatingComments,

	updateCount: function(action) {
		var countEl = $('#feedback_comments_validating_count');
		var count = parseInt(countEl.text());

		if (action == 'add') {
			count++;
		} else {
			count--;
		}

		if (count < 0) {
			count = 0;
		}

		var countEl = $('#feedback_comments_validating_count').text(count);

		DeskPRO_Window.sections.feedback_section.recountBadge();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.FeedbackContentValidating = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.PublishValidatingContent,

	listRemove: function(el) {
		DeskPRO_Window.util.modCountEl($('#feedback_validating_count'), '-');
		DeskPRO_Window.sections.feedback_section.recountBadge();
		this.selectionBar.checkNone();
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TaskList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'task-list';
	},

	initPage: function(el) {
		var self = this;

		if (DeskPRO_Window.sections.tasks_section) {
			DeskPRO_Window.sections.tasks_section.doRelaodPage = false;
		}

		var control = new DeskPRO.Agent.PageHelper.TaskListControl(el, {
			menuVis:  this.getEl('menu_vis'),
			assignOb: this.getEl('assign_ob'),
			completeCountEl: this.getEl('complete_count')
		});

		control.addEvent('updateUi', function() {
			self.updateUi();
		});
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.Search = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'search';
		this.wrapper = null;
	},

	initPage: function(el) {
		this.wrapper = el;
	},

	initTypeList: function(listWrap) {

	},

	loadMore: function(loadName) {

	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.DealList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'deal-list';
                this.resultTypeName = 'basic';
		this.resultTypeId = 'general';
	},

	initPage: function(el) {
		var self = this;
		var openForEl = null;
                this._initDisplayOptions();


                this.listWrapper = $('section.deal-simple-list', this.wrapper);

		this.relatedContentList = new DeskPRO.Agent.PageHelper.RelatedContentList(this, {
			contentListEl: this.listWrapper
		});
		this.ownObject(this.relatedContentList);
		

	},

        _initDisplayOptions: function() {

		var self = this;

                // Sorting options
		var sortMenuBtn = $('.order-by-menu-trigger', this.wrapper).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', sortMenuBtn).text(label);

				var url = self.meta.refreshUrl;
				url = Orb.appendQueryData(url, 'order_by', prop);
                                DeskPRO_Window.loadListPane(url);
			}
		});
		this.ownObject(this.sortingMenu);

                var groupMenuBtn = $('.group-by-menu-trigger', this.wrapper).first();
		this.groupingMenu = new DeskPRO.UI.Menu({
			triggerElement: groupMenuBtn,
			menuElement: $('.group-by-menu', this.wrapper).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('group-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				$('.label', groupMenuBtn).text(label);

				var url = self.meta.refreshUrl;
				url = Orb.appendQueryData(url, 'group_by', prop);
                                DeskPRO_Window.loadListPane(url);
			
			}
		});
		this.ownObject(this.groupingMenu);

                this.displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'deal-filter',
			//resultId: this.meta.resultId,
			refreshUrl: this.meta.refreshUrl
		});
		this.ownObject(this.displayOptions);
        }

});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TwitterFollowers = new Orb.Class({
    Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

    initPage: function(el) {
        this.wrapper = $(el);
		this.content = $('.content', this.wrapper);
		var self = this;

		this.meta.fetchResultsUrl = this.meta.listUrl;

		DeskPRO_Window.getMessageBroker().sendMessage('twitter-section.list-activated', {
			listUrl: this.meta.listUrl
		});

		var helper = new DeskPRO.Agent.PageHelper.Twitter(this.content, this, {
			messageUrl: this.getMetaData('saveUserMessageUrl'),
			userArchiveHideCallback: function(row) {
				var pageHelper = self.resultsHelper,
					page = pageHelper.getCurrentPage(),
					numPages = pageHelper.getNumPages();

				pageHelper.adjustResultCount(-1);

				if (page < numPages) {
					var data = {};
					data.last = 1;
					data.page = page;

					setTimeout(function() {
						$.ajax({
							url: self.getMetaData('listUrl'),
							dataType: 'html',
							data: data,
							success: function(html) {
								var $html = $(html);
								self.content.find('.followers-list').append($html);
							}
						});
					}, 200);
				} else if (pageHelper.resultCount <= 0) {
					self.wrapper.find('.list-listing.no-results').show();
					self.wrapper.find('.results-nav').hide();
				}
			}
		});

		this.content.find('textarea').TextAreaExpander();

		var opt = {
			perPage: this.meta.perPage || 25,
			currentPage: this.meta.currentPage,
			totalCount: this.meta.totalCount,
			resultRowSelector: 'article.twitter-user',
			resultsContainer: this.content
		};
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);
    }

});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TwitterStatus = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
		this.TYPENAME = 'twitter-status-list';
		this.countReflected = {};
	},

	initPage: function(el) {
		this.wrapper = $(el);
		var self = this;

		DeskPRO_Window.getMessageBroker().sendMessage('twitter-section.list-activated', {
			listUrl: this.meta.statusListUrl
		});

		this.meta.fetchResultsUrl = this.meta.statusListUrl;

		this.header = $('.header', this.wrapper);
		this.content = $('.content', this.wrapper);

		this.twitterHelper = new DeskPRO.Agent.PageHelper.Twitter(this.content, this, {
			statusArchiveHideCallback: function(row) {
				var id = parseInt(row.data('status-id'), 10);
				if (id && !self.countReflected[id]) {
					self.countReflected[id] = true;
					self.resultsHelper.adjustResultCount(-1);
				}
				self._afterTweetRemoved(0);
			}
		});

		this._initHeader();
		this._initContent(this.content);
		this._initControls(this.content);

		this.wrapper.on('click', '.new-tweet-list-indicator', function() {
			self.reload();
		});

		var opt = {
			perPage: this.meta.perPage || 25,
			currentPage: this.meta.currentPage,
			totalCount: this.meta.totalCount,
			resultRowSelector: 'article.twitter-status',
			resultsContainer: this.content,
			preFetchCallback: function(data) {
				$.each(self._getDisplayOptions(), function(k, v) {
					if (/boolean|number|string/.test(typeof v)) {
						data.push({name: k, value: v});
					} else {
						$.each(v, function(kk, vv) {
							data.push({name: k + '[' + kk + ']', value: vv});
						});
					}
				});
				return data;
			},
			onPostSetNewResults: function(x, y, results) {
				self._afterLoading(results);
			}/*,
			infiniteScroll: true,
			infiniteScrollTarget: this.content.find('.twitter-status-list'),
			infiniteScrollLoadFilter: function(results) {
				return results.find('.row-item.twitter-status');
			}*/
		};
		this.resultsHelper = new DeskPRO.Agent.PageHelper.Results(this, opt);
		this.ownObject(this.resultsHelper);

		DeskPRO_Window.getMessageBroker().addMessageListener('agent.tweet-added', function (data) {
			self.adjustTweetCountsFromClientMessage(data, 1);
			self.adjustShownTweetsForTweetAdded(data);

			self.countReflected = {};
		});

		DeskPRO_Window.getMessageBroker().addMessageListener('agent.tweet-updated', function (data) {
			if (data.trigger_user_id && data.trigger_user_id == DESKPRO_PERSON_ID) {
				return;
			}

			if (typeof data.change_archived !== 'undefined') {
				if (data.change_archived) {
					// moved to archived, reduce counts
					self.adjustTweetCountsFromClientMessage(data, -1);
				} else {
					// moved to unarchived, increase counts
					self.adjustTweetCountsFromClientMessage(data, 1);
				}
			} else if (data.deleted) {
				self.adjustTweetCountsFromClientMessage(data, -1);
			}

			self.adjustShownTweetsForTweetUpdated(data);

			self.countReflected = {};
		});
	},

	adjustTweetCountsFromClientMessage: function(data, adjustAmount) {
		var accountId = data.account_id;

		if (this.countReflected[data.account_status_id]) {
			return;
		}

		if (this._tweetAppliesToPage(data) && this.resultsHelper && this.resultsHelper.options) {
			this.countReflected[data.account_status_id] = true;
			this.resultsHelper.adjustResultCount(adjustAmount);
		}
	},

	adjustShownTweetsForTweetAdded: function(data) {
		if (this.content.find('.twitter-status-' + data.account_status_id).length) {
			// tweet already shown
			return;
		}

		if (!this.resultsHelper || !this.resultsHelper.options) {
			// page destroyed
			return;
		}

		if (this._tweetAppliesToPage(data)) {
			if (this.resultsHelper.getCurrentPage() > 1) {
				this.adjustNewTweetIndicator(1);
			} else {
				this.addTweetToPage(data.account_status_id, data.tweet_html);
			}
		}
	},

	adjustNewTweetIndicator: function(adjust) {
		var newIndicator = this.wrapper.find('.new-tweet-list-indicator');
		var newCount = (newIndicator.data('new-count') || 0) + adjust;
		newIndicator.data('new-count', newCount);
		newIndicator.text(newCount == 1 ? '1 new tweet' : newCount + ' new tweets').show();
	},

	_tweetAppliesToPage: function(data) {
		if (!this.meta.accountId || this.meta.accountId != data.account_id) {
			return false;
		}

		if (data.is_from_self) {
			return (
				this.menuOptions.filter('[name=account]').is(':checked')
				|| this.meta.listRoute == 'agent_twitter_sent_list'
			);
		}

		var isInInbox = (
			$.inArray(data.status_type, ['direct', 'reply', 'mention', 'retweet']) !== -1
			|| data.is_favorited
		);

		switch (this.meta.listRoute) {
			case 'agent_twitter_mine_list':
				if (data.assignment !== 'agent:' + DESKPRO_PERSON_ID) {
					return false;
				}
				break;

			case 'agent_twitter_team_list':
				var hasOwnTeam = false;
				for (var i = 0; i < DESKPRO_TEAM_IDS.length; i++) {
					var teamId = DESKPRO_TEAM_IDS[i];
					if (data.assignment === 'agent_team:' + teamId) {
						// my teams' tweets
						hasOwnTeam = true;
						break;
					}
				}
				if (!hasOwnTeam) {
					return false;
				}
				break;

			case 'agent_twitter_unassigned_list':
				if (data.assignment !== '') {
					return false;
				}
				if (!isInInbox) {
					return false;
				}
				break;

			case 'agent_twitter_all_list':
				if (!isInInbox) {
					return false;
				}
				break;

			case 'agent_twitter_timeline_list':
				if (data.status_type !== 'timeline') {
					return false;
				}
				break;

			case 'agent_twitter_sent_list':
				// the true case is handled above
				return false;

			case 'agent_twitter_run_search':
				return false;

			default:
				return false;
		}

		if (this.meta.group) {
			switch (this.meta.group) {
				case 'type':
					if (this.meta.groupValue == 'favorite') {
						if (!data.is_favorited) {
							return false;
						}
					} else {
						if (data.status_type !== this.meta.groupValue) {
							return false;
						}
					}
					break;

				case 'agent':
					if (data.agent_id != this.meta.groupValue) {
						return false;
					}
					break;

				case 'team':
					if (data.agent_team_id != this.meta.groupValue) {
						return false;
					}
					break;
			}
		}

		return true;
	},

	adjustShownTweetsForTweetUpdated: function(data) {
		var row = this.content.find('.twitter-status-' + data.account_status_id);

		if (row.length) {
			if (typeof data.change_archived !== 'undefined') {
				var showArchived = this.menuOptions.filter('[name=archived]').is(':checked');
				if (data.change_archived && !showArchived) {
					this.removeTweetFromPage(data.account_status_id);
				}
			}
			if (data.deleted) {
				this.removeTweetFromPage(data.account_status_id);
			}
			if (data.reply_added_html && data.reply_added_id) {
				if (!row.find('.twitter-reply-' + data.reply_added_id).length) {
					var html = $(data.reply_added_html);
					row.find('.twitter-replies').append(html);
					$('.timeago', html).timeago();

					row.find('.reply-list').show();
				}
			}
			if (data.note_added_html  && data.note_added_id) {
				if (!row.find('.twitter-note-' + data.note_added_id).length) {
					var html = $(data.note_added_html);
					row.find('.note-list').append(html);
					$('.timeago', html).timeago();

					row.find('.status-notes').show();
				}
			}
			if (data.edited_html) {
				row.find('.main-status-body .status-text').html(data.edited_html);
			}
			if (data.retweeted) {
				var link = row.find('li.opt-trigger.retweet, li.opt-trigger.retweeted');
				link.addClass('retweeted').removeClass('retweet');
				link.find('label').text('Retweeted');
			}
			if (data.unretweeted) {
				var link = row.find('li.opt-trigger.retweet, li.opt-trigger.retweeted');
				link.addClass('retweet').removeClass('retweeted');
				link.find('label').text('Retweet');
			}
			if (data.favorited) {
				row.find('.add-favorite, .favorited').addClass('favorited').removeClass('add-favorite');
			}
			if (data.unfavorited) {
				row.find('.add-favorite, .favorited').addClass('add-favorite').removeClass('favorited');
			}
			if (typeof data.change_assignment !== 'undefined') {
				var opt = row.find('.agents_sel option[value="' + data.change_assignment + '"]');
				if (opt.length) {
					opt.closest('select').val(data.change_assignment);
					var label = opt.text().trim();
					if (data.change_assignment == 'agent:' + DESKPRO_PERSON_ID) {
						label = 'Me';
					}

					var labelEl = row.find('li.opt-trigger.agent label');
					if (data.assignment_picture) {
						labelEl.text(' ' + label).prepend($('<img class="agent-assign-icon" />').attr('src', data.assignment_picture));
					} else {
						labelEl.text(label);
					}
				}
			}
		} else {
			if (typeof data.change_archived !== 'undefined' && !data.change_archived) {
				if (this.resultsHelper.getCurrentPage() == 1) {
					this.addTweetToPage(data.account_status_id, data.tweet_html);
				}
			}
		}

		if (this.content.find('.twitter-reply-' + data.account_status_id).length) {
			if (data.deleted) {
				this.removeReplyFromPage(data.account_status_id);
			}
			if (data.edited_html) {
				var row = this.content.find('.twitter-reply-' + data.account_status_id);
				row.find('.status-text').html(data.edited_html);
			}
		}
	},

	addTweetToPage: function(account_status_id, html) {
		if (!this.resultsHelper || !this.resultsHelper.options) {
			// page destroyed
			return;
		}

		if (!this.countReflected[account_status_id]) {
			this.resultsHelper.adjustResultCount(1);
			this.countReflected[account_status_id] = true;
		}

		var $html = $(html);
		this.content.find('.twitter-status-list').prepend($html);
		this._afterLoading($html);

		this.adjustShownTweets();
	},

	adjustShownTweets: function() {
		var count = this.resultsHelper.updateShowingCount();

		if (count === false) {
			return;
		}

		if (count == 0) {
			this.wrapper.find('.list-listing.no-results').show();
		} else {
			this.wrapper.find('.list-listing.no-results').hide();
		}

		if (count > this.resultsHelper.options.perPage) {
			$(this.resultsHelper.options.resultRowSelector, this.resultsHelper.resultsContainer)
				.slice(this.resultsHelper.options.perPage - count)
				.remove();

			this.resultsHelper.updateShowingCount()
		}
	},

	removeTweetFromPage: function(account_status_id) {
		var el = this.content.find('.twitter-status-' + account_status_id).filter(':not(:animated)');
		if (el.length) {
			el.remove();
			if (!this.countReflected[account_status_id]) {
				this.resultsHelper.adjustResultCount(-1);
				this.countReflected[account_status_id] = true;
			}
			this._afterTweetRemoved(0);
		}
	},

	removeReplyFromPage: function(account_status_id) {
		var el = this.content.find('.twitter-reply-' + account_status_id);
		if (el.length) {
			var row = this.twitterHelper.closestRow(el);
			el.remove();
			if (!row.find('.twitter-replies .twitter-reply').length) {
				row.find('.reply-list').hide();
			}
		}
	},

	_afterTweetRemoved: function(delay) {
		var pageHelper = this.resultsHelper,
			page = pageHelper.getCurrentPage(),
			numPages = pageHelper.getNumPages();
		var self = this;

		if (!this.resultsHelper || !this.resultsHelper.options) {
			// page destroyed
			return;
		}

		pageHelper.updateShowingCount();

		if (page < numPages) {
			var data = this._getDisplayOptions();
			data.last = 1;
			data.page = page;

			setTimeout(function() {
				$.ajax({
					url: self.getMetaData('statusListUrl'),
					dataType: 'html',
					data: data,
					success: function(html) {
						var $html = $(html);
						self.content.find('.twitter-status-list').append($html);
						self._afterLoading($html);
					}
				});
			}, delay || 0);
		} else if (pageHelper.resultCount <= 0) {
			this.wrapper.find('.list-listing.no-results').show();
			this.wrapper.find('.results-nav').hide();
		}
	},

	_afterLoading: function(content) {
		if (!content) { content = this.content; }
		this._initContent(content);
		this._initControls(content);

		this.wrapper.find('.new-tweet-list-indicator').data('new-count', 0).hide();

		if (this.selectionBar) {
			this.selectionBar.updateCount();
		}
		if (this.resultsHelper && this.resultsHelper.options) {
			this.resultsHelper.updateShowingCount();
		}
	},

	_initHeader: function() {
		this._initSortByFields();
		this._initIncludeFields();

		var self = this;

		this.selectionBar = new DeskPRO.Agent.PageHelper.SelectionBar(this, {
			onButtonClick: function() {
				self.massActions.open();
			},
			onCountChange: function(count) {
				var isOpen = self.massActions.isOpen();

				if (count > 0 && !isOpen) {
					self.massActions.open();
				} else if (count <= 0 && isOpen) {
					self.massActions.close();
				}
			},
			checkSelector: '.twitter-status:not(.archived) input.item-select'
		});
		this.ownObject(this.selectionBar);

		this.massActions = new DeskPRO.Agent.PageHelper.MassActions(this, {
			isListView: false,
			applyAction: function(wrapper, formData) {
				var data = formData,
					myFormData = $('input, textarea, select', wrapper).serializeArray();

				$(myFormData).each(function(index, param) {
					data[param.name] = param.value;
				});

				wrapper.addClass('loading');

				$.ajax({
					type: 'POST',
					url: BASE_URL + "agent/twitter/status/ajax-mass-save.json",
					'data': data,
					'dataType': 'json',
					success: function() {
						self.massActions.close();
						self.reload();
					}
				}).done(function() {
					wrapper.removeClass('loading');
				});
			},
			closeOnApply: false,
			openAction: function(wrapper) {
				if (!wrapper.data('twitter-helper')) {
					wrapper.data('twitter-helper',
						new DeskPRO.Agent.PageHelper.Twitter($('#twitter-mass-action-overlay'), self)
					);
				}
			}
		});
		this.ownObject(this.massActions);
	},

	_initContent: function(content) {
		var self = this;

		$('.timeago', content).timeago();
		var list = content.find('.twitter-status-list');
		if (list.length && list.data('page') && this.resultsHelper) {
			this.resultsHelper.setPage(parseInt(list.data('page'), 10), true);
			this.resultsHelper.setResultCount(parseInt(list.data('total-count'), 10));
		}
	},

	_initControls: function(content) {
	},

	_initSortByFields: function() {
		var self = this;

		var sortMenuBtn = $('.order-by-menu-trigger', this.header).first();
		this.sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: $('.order-by-menu', this.header).first(),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by');
				var label = item.find('.label').text().trim();

				// Change the displayed label for some visual feedback
				$('.label label', sortMenuBtn).text(label);
				sortMenuBtn.find('.order-dir').hide();
				sortMenuBtn.find('.order-dir.' + prop.split('_').pop()).show();

				sortMenuBtn.data('dir', prop);

				self.sortingMenu.close();
				self.reload();
			}
		});
		this.ownObject(this.sortingMenu);
	},

	_initIncludeFields: function() {
		var self = this;

		this.menuOptions = this.header.find('.btn-controls input:checkbox');
		this.menuOptions.click(function() { self.reload(); });
	},

	_getDisplayOptions: function() {
		var options = {
			include: {}
		};

		if (this.menuOptions) {
			this.menuOptions.each(function() {
				var field = $(this);
				options.include[field.attr('name')] = field.attr('checked') ? 1 : 0;
			});
		}

		return options;
	},

	reload: function() {
		$.ajax({
			url: this.getMetaData('statusListUrl'),
			dataType: 'html',
			data: this._getDisplayOptions(),
			context: this,
			success: function(html) {
				this.content.html(html);
				this._afterLoading();
			}
		});
	},

	highlightStatus: function(id) {
		$('.twitter-status', this.content).removeClass('highlight');
		$('.status-'+id, this.content).addClass('highlight');
	},

	downlightStatus: function(id) {
		$('.twitter-status-'+id, this.content).removeClass('highlight');
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.ListPane');

DeskPRO.Agent.PageFragment.ListPane.TwitterSearch = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.TwitterStatus,

	initPage: function(el) {
		var self = this;

		this.parent(el);

		this.maxTwitterId = el.find('.twitter-status-list').attr('data-twitter-max-id');

		this.updateInterval = setInterval(function() {
			$.ajax({
				url: self.meta.statusListUrl,
				data: {since_id: self.maxTwitterId },
				dataType: 'html',
				success: function(html) {
					var $html = $(html).first();

					if ($html.data('added')) {
						self.maxTwitterId = $html.attr('data-twitter-max-id');
						self.resultsHelper.adjustResultCount($html.data('added'));

						if (self.resultsHelper.getCurrentPage() > 1) {
							self.adjustNewTweetIndicator($html.data('added'));
						} else {
							var adding = $html.find('.row-item.twitter-status');

							self.content.find('.twitter-status-list').prepend(adding);
							self._afterLoading(adding);
							self.adjustShownTweets();
						}
					}
				}
			});
		}, 60 * 1000);
	},

	destroy: function() {
		clearInterval(this.updateInterval);
	}
});

Orb.createNamespace('DeskPRO.Agent.PageFragment.List');

DeskPRO.Agent.PageFragment.List.TicketList = new Orb.Class({
	Extends: DeskPRO.Agent.PageFragment.ListPane.Basic,

	initializeProperties: function() {
		this.parent();
	},

	initPage: function(el) {
		var self = this;
		var attachPoint = this.getEl('ng_attach');

		this.wrapper = el;
		this.perPage = 50;
		this.filterId = parseInt(this.meta.filter_id) || 0;

		DeskPRO_Window.ngModule.dpInjector.invoke(['$compile', '$rootScope', '$q', '$timeout', function($compile, $rootScope, $q, $timeout) {
			self.$scope = $rootScope.$new();

			self.$scope.$safeApply = function(fn) {
				var phase = this.$root.$$phase;
				if(phase == '$apply' || phase == '$digest') {
					if(fn && (typeof(fn) === 'function')) {
						fn();
					}
				} else {
					this.$apply(fn);
				}
			};

			self.$q = $q;
			self.$timeout = $timeout;

			attachPoint.data('$ngControllerController', self);
			$compile(attachPoint.contents())(self.$scope);

			self.initScope();
		}]);

		this.addEvent('destroy', function() {
			if (self.queuedChangeEvents_timeout) {
				self.$timeout.cancel(self.queuedChangeEvents_timeout);
				self.queuedChangeEvents_timeout = null;
			}
			if (self.$scope) {
				self.$scope.$destroy();
				self.$scope = null;
			}
		});

		if (this.meta.filter_id) {
			DeskPRO_Window.sections.tickets_section.highlightFilterNav(
				this.meta.filter_id,
				this.meta.topGroupingOption || this.meta.topGroupingOption === 0 ? this.meta.topGroupingOption : null
			);
		}
	},

	initScope: function() {
		var $scope = this.$scope,
			$timeout = this.$timeout,
			self = this,
			startTickets,
			startTicketsBatch;

		startTickets = eval(this.getEl('ticket_json').html());

		if (DP_DEBUG) {
			console.log(startTickets);
		}

		startTicketsBatch = [[], [], []];
		for (var i = 0; i < startTickets.length; i++) {
			if (i <= 15) startTicketsBatch[0].push(startTickets[i]);
			else if (i <= 30) startTicketsBatch[1].push(startTickets[i]);
			else startTicketsBatch[2].push(startTickets[i]);
		}

		$scope.tickets              = startTickets;
		$scope.checkedTickets       = {};
		$scope.checkedTicketsCount  = 0;
		$scope.display_fields       = this.meta.display_fields || [];
		$scope.openTickets          = {};

		this.listTicketIds = eval(this.getEl('ticket_ids_json').html());

		this.updatePageCursorWithTicketId();
		this.realCursorStart = this.$scope.pageCursorStart;

		// Wait til after updatePageCursor since it needs full list to know proper cursor
		$scope.tickets = startTicketsBatch[0];

		this.getEl('ticket_json').remove();
		this.getEl('ticket_ids_json').remove();

		this._initDisplayOptions();
		this._initListChangeEvents();
		this._initMassActions();
		this._initNavControls();

		$timeout(function() {
			if (startTicketsBatch[1].length) {
				startTicketsBatch[1].forEach(function(t) {
					$scope.tickets.push(t);
				});

				$timeout(function() {
					if (startTicketsBatch[2].length) {
						startTicketsBatch[2].forEach(function(t) {
							$scope.tickets.push(t);
						});
						self.updatePageCursorWithTicketId();
						$timeout(function() {
							$scope.isLoaded = true;
						}, 0);
					} else {
						$scope.isLoaded = true;
					}
				}, 10);
			} else {
				$scope.isLoaded = true;
			}
		}, 10);
	},

	//#########################################################################
	//# Paging and cursor
	//#########################################################################

	/**
	 * When tickets are added or removed then we should update the counter/cursor vars.
	 * This calculates the page cursor based on the first displayed ticket and where it appears
	 * in the list of all ticket IDs.
	 */
	updatePageCursorWithTicketId: function() {
		var $scope = this.$scope,
			displayTicketId,
			startIdx;

		$scope.ticketCount = this.listTicketIds.length;

		if ($scope.ticketCount) {
			displayTicketId = $scope.tickets[0].id;
			startIdx = this.listTicketIds.indexOf(displayTicketId);

			$scope.pageCursorStart = startIdx+1;
			$scope.pageCursorEnd = startIdx + $scope.tickets.length;

			if ($scope.pageCursorEnd > $scope.ticketCount) {
				$scope.pageCursorEnd = $scope.ticketCount;
			}
		} else {
			$scope.pageCursorStart = 0;
			$scope.pageCursorEnd = 0;
		}

		if ($scope.pageCursorStart != 1) {
			$scope.hasPrevPage = true;
		} else {
			$scope.hasPrevPage = false;
		}

		if ($scope.pageCursorEnd < $scope.ticketCount) {
			$scope.hasNextPage = true;
		} else {
			$scope.hasNextPage = false;
		}
	},

	//#########################################################################
	//# Ticket List Change Events
	//#########################################################################

	_initListChangeEvents: function() {
		var self = this, $scope = this.$scope, wrapperEl = this.wrapper;

		this.queuedChangeEvents_timeout = null;
		this.queuedChangeEvents = {'addTicketResults': [], 'removeTicketResults': [], 'refreshTicketResults': []};

		this.fieldUtil  = DeskPRO.Agent.PageFragment.List.TicketList.FieldUtil;
		this.orderBy    = this.meta.orderBy.replace(/^ticket\./, '');
		this.orderByDir = this.meta.orderByDir.toUpperCase();

		$scope.realtime = true;
		$scope.halfrealtime = false;
		$scope.massActionsOpen = false;

		this.groupingTerms = [];
		if (this.meta.topGroupingTerm) {
			if (this.meta.topGroupingOption.match(/^\d+/)) {
				this.meta.topGroupingOption = parseInt(this.meta.topGroupingOption);
			}
			this.groupingTerms.push({ field: this.meta.topGroupingTerm, value: this.meta.topGroupingOption || 0 });
		}
		if (this.meta.groupBy) {
			$scope.$watch('ticketCount', function(newCount, oldCount) {
				var diff = newCount - oldCount;
				var groupCountEl = self.getEl('total_grouped_count').find('span');
				var currentCount = parseInt(groupCountEl.text()) + diff;
				groupCountEl.text(currentCount);
			});
		}
		if (this.meta.groupBy && this.meta.groupByOption && this.meta.groupByOption != 'DP_NOT_SET') {
			if (this.meta.groupByOption.match(/^\d+/)) {
				this.meta.groupByOption = parseInt(this.meta.groupByOption);
			}
			this.groupingTerms.push({ field: this.meta.groupBy, value: this.meta.groupByOption || 0 });
		}

		if (this.groupingTerms[0]) {
			this.isClientSideGroupingLogic = this.fieldUtil.isSupportedField(this.groupingTerms[0].field);
		}
		if (this.isClientSideGroupingLogic && this.groupingTerms[1]) {
			this.isClientSideGroupingLogic = this.fieldUtil.isSupportedField(this.groupingTerms[1].field);
		}

		// Events about updates
		// More updates happen in the Section.Tickets controller where
		// we are told about specific additions/removals of tickets to the list
		// Those events are called directly on this controller as addTicketResults/removeTicketResults
		DeskPRO_Window.getMessageBroker().addMessageListener('tickets.deleted', function(ticket_ids) {
			self.queueChangeEvent('removeTicketResults', ticket_ids);
		}, null, [this.OBJ_ID]);

		DeskPRO_Window.getMessageBroker().addMessageListener('agent.ticket-updated', function(info) {
			var ticketId = parseInt(info.ticket_id),
				currentlyInView,
				isInFilter = false;

			if (self.listTicketIds.indexOf(ticketId) !== -1) {
				isInFilter = true;
			}
			if (!isInFilter && self.filterId && DeskPRO_Window.sections.tickets_section && DeskPRO_Window.sections.tickets_section.filterTicketIds[self.filterId]) {
				if (DeskPRO_Window.sections.tickets_section.filterTicketIds[self.filterId].indexOf(ticketId) !== -1) {
					isInFilter = true;
				}
			}

			if (!isInFilter) {
				return;
			}

			currentlyInView = $scope.tickets.filter(function(x) { return x.id === ticketId; }).length === 1;
			if (currentlyInView) {
				self.queueChangeEvent('refreshTicketResults', [ticketId]);
			} else {
				self.queueChangeEvent('addTicketResults', [ticketId]);
			}
		}, null, [this.OBJ_ID]);

		if (this.meta.groupBy && this.filterId) {
			DeskPRO_Window.getMessageBroker().addMessageListener('agent.filter-update', function(data) {
				var filterId = parseInt(data.filter_id);
				var ticketId = parseInt(data.ticket_id || 0);
				if (filterId == self.filterId) {
					if (ticketId && data.op) {
						if (data.op == 'add') {
							if (!self.isClientSideGroupingLogic) {
								self.refreshCursor(null, true);
								self.updateSubgroupingBubbles('refresh');
							} else {
								self.updateSubgroupingBubbles('refresh');
								if ($scope.tickets.filter(function (x) {
									return x.id === ticketId;
								}).length === 1) {
									self.queueChangeEvent('refreshTicketResults', [ticketId]);
								} else {
									self.queueChangeEvent('addTicketResults', [ticketId]);
								}
							}
						} else if (data.op == 'del') {
							self.queueChangeEvent('removeTicketResults', [ticketId]);
							self.updateSubgroupingBubbles('refresh');
						}
					}
				}
			}, null, [this.OBJ_ID]);
		}

		// Tab indicator
		this.addEvent('watchedTabAdded', function(tab) {
			var ticketId = parseInt(tab.page.meta.ticket_id);
			if (ticketId) {
				$scope.openTickets[ticketId] = true;
				wrapperEl.find('.ticket-row-' + ticketId).addClass('open');
			}
		});
		this.addEvent('watchedTabRemoved', function(tab) {
			var ticketId = parseInt(tab.page.meta.ticket_id);
			if (ticketId) {
				$scope.openTickets[ticketId] = false;
				wrapperEl.find('.ticket-row-' + ticketId).removeClass('open');
			}
		});
		DeskPRO_Window.getTabWatcher().addTabTypeWatcher('ticket', this, true);
	},


	/**
	 * Queues a change event. This is mainly to de-bounce incoming events from client messages.
	 *
	 * @param {String} type
	 * @param {Array} ticketIds
	 */
	queueChangeEvent: function(type, ticketIds) {
		var self = this,
			$timeout = this.$timeout;

		ticketIds.forEach(function(tid) {
			if (self.queuedChangeEvents[type].indexOf(tid) === -1) {
				self.queuedChangeEvents[type].push(parseInt(tid));
			}
		});

		if (!this.queuedChangeEvents_timeout) {
			this.queuedChangeEvents_timeout = $timeout(function() {
				var events = self.queuedChangeEvents;
				self.queuedChangeEvents = {'addTicketResults': [], 'removeTicketResults': [], 'refreshTicketResults': []};
				self.queuedChangeEvents_timeout = null;

				if (events.removeTicketResults.length) {
					self.removeTicketResults(events.removeTicketResults);
				}
				if (events.refreshTicketResults.length) {
					self.refreshTicketResults(events.refreshTicketResults);
				}
				if (events.addTicketResults.length) {
					self.addTicketResults(events.addTicketResults);
				}
			}, 600);
		}
	},


	/**
	 * Called when a new ticket is added to the main result set. Note that just because it was
	 * added to the *main* result set doesn't mean it should be added to the actual list
	 * we're viewing.
	 *
	 * E.g.:
	 * - We are on page1 and the result is added to the end of the list on page3
	 * - We are viewing a sub-group of the set (e.g, 'All Tickets > By agent > Me'), so the ticket
	 * might not apply at all.
	 *
	 * So just because you add a ticket result here doesn't neccessarily mean the list is updated
	 * at all. This method does proper logic for detecting which tickets should be displayed.
	 *
	 * Note: This should still only be called when the tickets affect the current list. Eg.,
	 * we are viewing filter#4 then only new tickets added to filter#4 should be added here.
	 * The logic only knows about pages/grouping, not about full filter criteria--that is still
	 * done server-side.
	 *
	 * @param {Array<Integer>} ticketIds
	 * @return {promise}
	 */
	addTicketResults: function(ticketIds) {
		var self = this,
			$scope = this.$scope,
			currentTicketIdsMap = {},
			didAdd = [],
			appendIds = [],
			lastId = null,
			promise,
			tmp;

		console.log("[TicketList.addTicketResult] %o", ticketIds);

		if (!$scope.realtime) {
			$scope.hasUnloadedUpdates = true;
			return;
		}

		$scope.tickets.forEach(function(t) { currentTicketIdsMap[t.id] = true });
		ticketIds = ticketIds.filter(function(tid) { return !currentTicketIdsMap[tid]; });

		if (!ticketIds.length) {
			return;
		}

		promise = this.getTicketRows(ticketIds);
		promise.then(function(tickets) {
			var firstId = $scope.tickets[0] ? $scope.tickets[0].id : null,
				newFirstTicketIdx = null,
				listTicketIdsMap;

			// Re-gen the map because it could change if another request
			// was made while this one was still processing
			currentTicketIdsMap = {};
			$scope.tickets.forEach(function(t) { currentTicketIdsMap[t.id] = true });

			listTicketIdsMap = {};
			self.listTicketIds.forEach(function(tid) { listTicketIdsMap[tid] = true; });

			tickets.forEach(function(ticket) {
				if (!currentTicketIdsMap[ticket.id] && self.isTicketGroupMatch(ticket)) {
					$scope.tickets.push(ticket);
					didAdd.push(ticket.id);

					if (!listTicketIdsMap[ticket.id]) {
						self.updateSubgroupingBubbles('add', ticket);
					}
				}
			});

			if (didAdd.length) {

				$scope.tickets.sort(function(ticketA, ticketB) {
					return self.fieldUtil.getOrder(ticketA, ticketB, self.orderBy, self.orderByDir);
				});

				// Add to IDs array
				$scope.tickets.forEach(function(ticket, idx) {
					if (didAdd.indexOf(ticket.id) !== -1) {
						if (!listTicketIdsMap[ticket.id]) {
							if (!lastId) {
								if (idx === 0) {
									self.listTicketIds.unshift(ticket.id);
								} else {
									self.listTicketIds.push(ticket);
								}
							} else {
								tmp = self.listTicketIds.indexOf(lastId);
								if (tmp !== -1) {
									self.listTicketIds.splice(tmp, 0, ticket.id);
								} else {
									appendIds.push(ticket.id);
								}
							}
						}
					}
					lastId = ticket.id;
				});
				if (appendIds.length) {
					appendIds.forEach(function(tid) {
						if (!listTicketIdsMap[tid]) {
							self.listTicketIds.push(tid);
						}
					});
				}

				// Truncate list to max perPage
				if ($scope.tickets.length >= self.perPage) {

					if (self.realCursorStart !== 1 && firstId) {
						for (var i = 0; i < $scope.tickets.length; i++) {
							if ($scope.tickets[i].id === firstId) {
								newFirstTicketIdx = i;
								break;
							}
						}
					}

					if (!newFirstTicketIdx) {
						newFirstTicketIdx = 0;
					}

					$scope.tickets = $scope.tickets.slice(newFirstTicketIdx, newFirstTicketIdx+self.perPage);
				}

				self.updatePageCursorWithTicketId();
			}
		});

		return promise;
	},


	/**
	 * Called when a new ticket is removed from the current result set.
	 *
	 * @param {Array<Integer>} ticketIds
	 * @return void
	 */
	removeTicketResults: function(ticketIds) {
		var $scope = this.$scope,
			self = this,
			removeTicketIdsMap,
			didRemoveList,
			loadExtra,
			loadExtraStartIdx,
			loadExtraEndIdx;

		console.log("[TicketList.removeTicketResult] %o", ticketIds);

		if (!$scope.realtime && !$scope.halfrealtime) {
			$scope.hasUnloadedUpdates = true;
			return;
		}

		removeTicketIdsMap = {};
		didRemoveList = {};
		ticketIds.forEach(function(x) { removeTicketIdsMap[x] = true; });

		$scope.tickets = $scope.tickets.filter(function(t) {
			if (removeTicketIdsMap[t.id]) {
				self.updateSubgroupingBubbles('remove', t);
				didRemoveList[t.id] = true;
				return false;
			} else {
				return true;
			}
		});
		this.listTicketIds = this.listTicketIds.filter(function(tid) {
			if (removeTicketIdsMap[tid]) {
				if (!didRemoveList[tid]) {
					self.updateSubgroupingBubbles('refresh');
				}
				return false;
			} else {
				return true;
			}
		});

		// If we have less than the per page, then get the next page results and bring them in here
		if ($scope.realtime && $scope.tickets.length < this.perPage && this.listTicketIds.length > $scope.tickets.length) {
			if ($scope.tickets.length) {
				loadExtraStartIdx = this.listTicketIds.indexOf($scope.tickets[$scope.tickets.length-1].id) + 1;
			}
			if (!loadExtraStartIdx || loadExtraStartIdx === -1) {
				loadExtraStartIdx = 0;
			}

			loadExtraEndIdx = loadExtraStartIdx + (this.perPage - $scope.tickets.length);
			loadExtra = this.listTicketIds.slice(loadExtraStartIdx, loadExtraEndIdx);
			$scope.$safeApply(function() {
				self.getTicketRows(loadExtra).then(function(tickets) {
					var currentTicketIdsMap = {}, didAdd;
					$scope.tickets.forEach(function(t) { currentTicketIdsMap[t.id] = true });

					tickets.forEach(function(ticket) {
						if (self.listTicketIds.indexOf(ticket.id) !== -1 && !currentTicketIdsMap[ticket.id]) {
							$scope.tickets.push(ticket);
							didAdd = true;
						}
					});
					if (didAdd) {
						$scope.tickets.sort(function(ticketA, ticketB) {
							return self.fieldUtil.getOrder(ticketA, ticketB, self.orderBy, self.orderByDir);
						});
						self.updatePageCursorWithTicketId();
					}
				});
			});
		} else {
			this.updatePageCursorWithTicketId();
			$scope.$safeApply();
		}
	},


	/**
	 * Called to refresh display of specific tickets in the current view.
	 *
	 * Note: This only refreshes tickets in the current view (e.g, within current 50 ticket page).
	 *
	 * @param {Array<Integer>} ticketIds
	 * @return {promise}
	 */
	refreshTicketResults: function(ticketIds) {
		var $scope = this.$scope,
			self = this,
			validTicketIdsMap = {},
			promise;

		console.log("[TicketList.refreshTicketResult] %o", ticketIds);

		if (!$scope.realtime && !$scope.halfrealtime) {
			$scope.hasUnloadedUpdates = true;
			return;
		}

		if (!$scope.tickets || !$scope.tickets.length) {
			return;
		}

		$scope.tickets.forEach(function(t) { validTicketIdsMap[t.id] = true });
		ticketIds = ticketIds.filter(function(tid) { return !!validTicketIdsMap[tid]; });

		if (!ticketIds.length) {
			return;
		}

		promise = this.getTicketRows(ticketIds);
		promise.then(function (tickets) {
			self.applyTicketData(tickets);
		});

		return promise;
	},


	/**
	 * Applies an array of ticket data to the current view.
	 * This updates existing ticket data models, does not do anything to load/add/remove
	 * (use other methods for that).
	 *
	 * @param {Array} tickets
	 */
	applyTicketData: function(tickets) {
		var $scope = this.$scope,
			self = this,
			didChange = false,
			hasOutofviewChange = false,
			removeIds = [];

		if (!tickets || !tickets.length) {
			return;
		}

		tickets.forEach(function(newTicket) {
			var found = false;
			if (!self.isTicketGroupMatch(newTicket)) {
				found = true;
				removeIds.push(newTicket.id);
			} else {
				for (var i = 0; i < $scope.tickets.length; i++) {
					if ($scope.tickets[i].id == newTicket.id) {
						found = true;
						self.updateSubgroupingBubbles('remove', $scope.tickets[i]);
						self.updateSubgroupingBubbles('add', newTicket);
						$scope.tickets[i] = newTicket;
						didChange = true;
					}
				}
			}
			if (!found) {
				hasOutofviewChange = true;
			}
		});

		if (didChange) {
			$scope.tickets.sort(function(ticketA, ticketB) {
				return self.fieldUtil.getOrder(ticketA, ticketB, self.orderBy, self.orderByDir);
			});
		}

		if (hasOutofviewChange) {
			self.updateSubgroupingBubbles('refresh');
		}
		if (removeIds.length) {
			this.removeTicketResults(removeIds);
		}
	},


	/**
	 * Applies some arbitrary data to a ticket in the current list view.
	 * Use this to apply specific known changes to the view.
	 *
	 * @param {Integer} ticketId
	 * @param {Object} data Data to apply
	 */
	mergeTicketData: function(ticketId, data) {
		var $scope = this.$scope,
			idx = null,
			newTicket;

		$scope.tickets.forEach(function(ticket, i) {
			if (ticket.id != ticketId) return;
			newTicket = _.extend({}, ticket, data || {});
			idx = i;
		});

		if (idx !== null) {
			$scope.$safeApply(function() {
				$scope.tickets.splice(idx, 1, newTicket);
			});
		}
	},


	/**
	 * Given a ticket model object, check if it belongs in the list based on grouping vals.
	 * For example, if viewing grouped by agent and I have selected 'me', then only tickets with ticket.agent.id == me
	 * would return true.
	 *
	 * @param {Object} ticket
	 * @returns {boolean}
	 */
	isTicketGroupMatch: function(ticket) {
		var groupMatchCount = 0,
			self = this;

		if (!this.groupingTerms.length) {
			return true;
		}

		this.groupingTerms.forEach(function(groupInfo) {
			if (self.fieldUtil.checkEquality(ticket, groupInfo.field, groupInfo.value)) {
				groupMatchCount++;
			}
		});

		if (groupMatchCount < this.groupingTerms.length) {
			return false;
		}

		return true;
	},


	/**
	 * Loads raw JSON data for specified ticket IDs
	 *
	 * @param ticketIds
	 * @returns {promise}
	 */
	getTicketRows: function(ticketIds) {
		var def = this.$q.defer(),
			formData = [];

		if (!ticketIds || !ticketIds.length) {
			def.resolve([]);
			return def.promise;
		}

		ticketIds.forEach(function(tid) {
			formData.push({ name: 'ticket_ids[]', value: tid });;
		});

		$.ajax({
			url: BASE_URL + "agent/ticket-search/ticket-rows.json",
			type: 'GET',
			dataType: 'json',
			data: formData,
			noErrorOverride: true,
			success: function(data) {
				def.resolve(data);
			},
			error: function() {
				def.reject();
			}
		});

		return def.promise;
	},


	/**
	 * Loads ticket rows with change data to preview changes.
	 *
	 * @param ticketIds
	 * @param changes
	 * @returns {promise}
	 */
	getTicketChangePreviewRows: function(ticketIds, changes, runSingle) {
		var def = this.$q.defer(),
			formData = [];

		if (runSingle && this.runningChangePreviewAjax) {
			this.runningChangePreviewAjax.abort();
			this.runningChangePreviewAjax = null;
		}

		if (!ticketIds || !ticketIds.length || !changes || !changes.length) {
			def.resolve([]);
			return def.promise;
		}

		ticketIds.forEach(function(tid) {
			formData.push({ name: 'ticket_ids[]', value: tid });;
		});

		changes.forEach(function(c) {
			formData.push(c);
		});

		this.runningChangePreviewAjax = $.ajax({
			url: BASE_URL + "agent/ticket-search/ticket-rows.json",
			type: 'POST',
			dataType: 'json',
			data: formData,
			noErrorOverride: true,
			complete: function() {
				this.runningChangePreviewAjax = null;
			},
			success: function(data) {
				def.resolve(data);
			},
			error: function() {
				def.reject();
			}
		});

		return def.promise;
	},


	/**
	 * Applies data from getTicketChangePreviewRows to the current ticket array so the changes
	 * are visible.
	 *
	 * @param {Array} tickets
	 */
	applyTicketChangePreviews: function(tickets) {
		var ticketMap = {};
		tickets.forEach(function(t) { ticketMap[t.id] = t; });

		this.$scope.tickets.forEach(function(ticket) {
			if (ticketMap[ticket.id]) {
				ticket.preview_changes = ticketMap[ticket.id];

				if (!ticket.version_id) ticket.version_id = 0;
				ticket.version_id++;
			}
		});
		console.log(this.$scope.tickets);
	},


	/**
	 * Clear preview data from all tickets
	 */
	clearAllTicketChangePreviews: function() {
		this.$scope.tickets.forEach(function(ticket) {
			if (ticket.preview_changes) {
				ticket.preview_changes = null;
				delete ticket.preview_changes;

				if (!ticket.version_id) ticket.version_id = 0;
				ticket.version_id++;
			}
		});
	},


	/**
	 * Clear preview data from specific tickets
	 *
	 * @param {Array} ticketIds      Clear these ticket IDs
	 * @param {Array} notTicketIds   Clear tickets that are not these IDs
	 */
	clearTicketChangePreviews: function(ticketIds, notTicketIds) {
		var map = null, notMap = null;

		if (ticketIds) {
			map = {};
			ticketIds.forEach(function(t) { map[t] = true; });
		}
		if (notTicketIds) {
			notMap = {};
			notTicketIds.forEach(function(t) { notMap[t] = true; });
		}

		this.$scope.tickets.forEach(function(ticket) {
			if ((map && map[ticket.id]) || (notMap && !notMap[ticket.id])) {
				if (ticket.preview_changes) {
					ticket.preview_changes = null;
					delete ticket.preview_changes;

					if (!ticket.version_id) ticket.version_id = 0;
					ticket.version_id++;
				}
			}
		});
	},


	/**
	 * Updates grouping bubble with some info about what happened.
	 * This is called automatically when a ticket is updated. If we know how to handle
	 * a grouping field, we can update the grouping counts now. Otherwise, we need to
	 * refresh on the server side.
	 *
	 * @param op
	 * @param ticket
	 */
	updateSubgroupingBubbles: function(op, ticket) {
		var self = this,
			groupingBar,
			ticketValue,
			foundBubble,
			$timeout = this.$timeout;

		if (!this.meta.groupBy) {
			return;
		}

		groupingBar = this.getEl('grouping_bar');

		if (!ticket) {
			op = 'refresh';
		}
		if (op != 'refresh') {
			ticketValue = this.fieldUtil.getFieldValue(this.meta.groupBy, ticket);
			if (ticketValue === '__UNKNOWN__') {
				op = 'refresh';
			}
		}
		if (op != 'refresh') {
			if (ticketValue === null) {
				ticketValue = 0;
			}
			groupingBar.find('li').each(function() {
				var el = $(this), num;
				if (el.data('grouping-option') == ticketValue) {
					foundBubble = el;
					num = parseInt(el.find('span').text().trim() || 0);
					if (op == 'add') {
						num++;
					} else {
						num--;
					}
					el.find('span').text(num);
					if (num == 0) {
						el.hide();
					} else {
						el.show();
					}
				}
			});
			if (!foundBubble) {
				op = 'refresh';
			}
		}

		if (op == 'refresh') {
			$timeout(function() {
				self.refreshSubgroupNumbers();
			}, 100);
		}
	},


	/**
	 * Refreshes the subgroup changes from the server.
	 */
	refreshSubgroupNumbers: function() {
		var self = this;
		if (!this.meta.refreshSubgroupCounts) {
			return;
		}

		$.ajax({
			url: this.meta.refreshSubgroupCounts,
			success: function(data) {
				var groupingBar = self.getEl('grouping_bar');
				if (!data.group_display || !data.group_display.counts) {
					return;
				}

				var touched = [];

				for (var k in data.group_display.counts) {
					if (!data.group_display.counts.hasOwnProperty(k)) continue;
					groupingBar.find('li').each(function() {
						var el = $(this), num = data.group_display.counts[k].total || 0;
						if (el.data('grouping-option') == k) {
							touched.push(this);
							el.find('span').text(num);
							if (num == 0) {
								el.hide();
							} else {
								el.show();
							}
						}
					});
				}

				// Ones with no numbers need to be hidden
				groupingBar.find('li').each(function() {
					if (touched.indexOf(this) === -1) {
						$(this).hide().find('span').text('0');
					}
				});
			}
		});
	},

	//#########################################################################
	//# Mass Actions
	//#########################################################################

	_initMassActions: function() {
		var self = this,
			$scope = this.$scope;

		//------------------------------
		// Checkbox management
		//------------------------------

		$scope.uncheckTicketId = function(ticketId) {
			if ($scope.checkedTickets[ticketId]) {
				delete $scope.checkedTickets[ticketId];
				$scope.checkedTicketsCount--;
			}
		};

		$scope.$watch('checkedTickets', function(x) {
			$scope.checkedTicketsCount = 0;
			for (var key in x) {
				if (x[key] === true) {
					$scope.checkedTicketsCount++;
				}
			}

			if ($scope.checkedTicketsCount == $scope.tickets.length) {
				$scope.checkedTicketsToggle = true;
			} else {
				$scope.checkedTicketsToggle = false;
			}

			if ($scope.checkedTicketsCount && !self.massActions) {
				$scope.openMassActions();
			} else if (!$scope.checkedTicketsCount && self.massActions) {
				self.massActions.close();
			}

			self.updateMassActionPreviewsStatus();
		}, true);

		$scope.checkAllTickets = function(isChecked) {
			if (isChecked) {
				$scope.checkedTickets = {};
				$scope.tickets.forEach(function(x) { $scope.checkedTickets[x.id] = true; });
			} else {
				$scope.checkedTickets = {};
			}
		};

		//------------------------------
		// Mass actions overlay
		//------------------------------

		$scope.openMassActions = function() {
			if (!self.massActions) {
				self.massActions = new DeskPRO.Agent.PageFragment.List.TicketList.MassActions({
					templateElement: self.wrapper.find('.mass-actions-overlay-tpl'),
					"$scope": self.$scope,
					onPostApply: function(inst, data, info) {
						$scope.$safeApply(function() {
							$scope.checkedTickets = {};
							self.clearAllTicketChangePreviews();

							if (data.ticket_data) {
								self.applyTicketData(data.ticket_data);
							}
						});
					},
					getCheckedIds: function() {
						var ids = [];
						for (var tid in $scope.checkedTickets) {
							if ($scope.checkedTickets[tid] === true) {
								ids.push(tid);
							}
						}

						return ids;
					},
					onClosed: function() {
						if (self.massActions) {
							self.massActions.destroy();
						}

						$scope.$safeApply(function() {
							self.clearAllTicketChangePreviews();
							$scope.checkedTickets = {};
						});

						self.massActions = null;
					},
					onFormUpdated: function(changes) {
						self.updateMassActionPreviews(changes);
					}
				});
			}

			self.massActions.open();
		};

		this.updateMassActionPreviewsDebounced = _.debounce(this.updateMassActionPreviews, 500);
	},

	updateMassActionPreviewsStatus: function() {
		var $scope = this.$scope,
			ids = [],
			self = this;

		for (var i in $scope.checkedTickets) {
			if ($scope.checkedTickets.hasOwnProperty(i)) {
				ids.push(parseInt(i));
			}
		}

		$scope.$safeApply(function() {
			if (!ids.length) {
				self.clearAllTicketChangePreviews();
			} else {
				self.clearTicketChangePreviews(null, ids);
			}
		});
	},

	updateMassActionPreviews: function(changes) {
		var $scope = this.$scope,
			ids = [],
			self = this;

		for (var i in $scope.checkedTickets) {
			if ($scope.checkedTickets.hasOwnProperty(i)) {
				ids.push(parseInt(i));
			}
		}

		if (!ids.length || !changes.length) {
			$scope.$safeApply(function() {
				self.clearAllTicketChangePreviews();
			});
			return;
		}

		// Clear all previews except for ones we want
		this.clearTicketChangePreviews(null, ids);

		// Load preview data for selected tickets
		this.getTicketChangePreviewRows(ids, changes, true).then(function(data) {
			$scope.$safeApply(function() {
				self.applyTicketChangePreviews(data);
			});
		});
	},

	//#########################################################################
	//# Display options
	//#########################################################################

	_initDisplayOptions: function() {
		var $scope = this.$scope,
			$timeout = this.$timeout,
			wrapperEl = this.wrapper,
			self = this,
			displayOptions,
			sortMenuBtn,
			sortingMenu,
			groupMenuBtn,
			groupingMenu;

		$scope.previewMaxWidthCalc = function(element, targetElement, attrs, scope) {
			var pane = $('#dp_list'),
				maxW;

			maxW = pane.width();

			// Minus the indent of the element to the row (its aligned to the link)
			maxW -= (element.offset().left - pane.offset().left);

			// Some tolerance
			maxW -= 25;

			if (maxW < 300) {
				maxW = 300;
			}

			return maxW;
		};

		$scope.isFieldDisplayable = function(ticket, field) {
			var fieldM;
			switch (field) {
				case 'ref':
				case 'agent':
				case 'agent_team':
				case 'date_created':
					return true;
				case 'date_user_waiting':
					return !!ticket.date_user_waiting;
				case 'date_resolved':
					return !!ticket.date_resolved;
				case 'total_user_waiting':
					return (ticket.total_user_waiting || ticket.date_user_waiting);
				case 'date_last_user_reply':
					return !!ticket.date_last_user_reply;
				case 'date_last_agent_reply':
					return !!ticket.date_last_agent_reply;
				case 'date_last_reply':
					return (ticket.date_last_user_reply || ticket.date_last_agent_reply);
				case 'department':
					return !!ticket.department;
				case 'language':
					return !!ticket.language;
				case 'product':
					return !!ticket.product;
				case 'category':
					return !!ticket.category;
				case 'priority':
					return !!ticket.priority;
				case 'workflow':
					return !!ticket.workflow;
				case 'organization':
					return !!ticket.organization;
				case 'labels':
					return ticket.labels && ticket.labels.length > 0;
				case 'slas':
					return ticket.ticket_slas && ticket.ticket_slas.length > 0;
				default:
					fieldM = field.match(/^ticket_fields\[(\d+)\]$/);
					if (fieldM) {
						if (ticket['field' + fieldM[1]]) {
							return true;
						}
					} else {
						fieldM = field.match(/^person_fields\[(\d+)\]$/);
						if (fieldM) {
							if (ticket.person['field' + fieldM[1]]) {
								return true;
							}
						}
					}
					return false;
			}
		};

		displayOptions = new DeskPRO.Agent.PageHelper.DisplayOptions(this, {
			prefId: 'ticket-' + this.meta.resultTypeName,
			resultId: this.meta.resultTypeId,
			refreshUrl: this.meta.refreshUrl,
			isListView: false,
			refreshCallback: function(info) {
				// Updates to sort order must always refresh
				if (info.context.isSortUpdate) {
					$scope.$safeApply(function() {
						$scope.refreshCursorLoading = true;
					});
					DeskPRO_Window.loadListPane(self.meta.refreshUrl);

				// Otherwise its a display field update, we can just
				// update the display fields and angular will update the view
				} else {
					$scope.display_fields = info.displayFields;
					$scope.$apply();
				}
			}
		});
		this.ownObject(displayOptions);

		// Sorting options
		sortMenuBtn = wrapperEl.find('.order-by-menu-trigger');
		sortingMenu = new DeskPRO.UI.Menu({
			triggerElement: sortMenuBtn,
			menuElement: wrapperEl.find('.order-by-menu'),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('order-by');
				var label = item.find('.label').text().trim();

				// Change the displayed label for some visual feedback
				sortMenuBtn.find('.label label').text(label);
				sortMenuBtn.find('.order-dir').hide();
				sortMenuBtn.find('.order-dir.' + prop.split('_').pop()).show();


				var disOptWrap = displayOptions.getWrapperElement();
				var sel = disOptWrap.find('select.sel-order-by');
				sel.find('option').prop('selected', false);
				sel.find('option.' + prop).prop('selected', true);

				if(wrapperEl.find('header.list-grouping-bar').css('display') == 'block') {
					wrapperEl.find('header.list-grouping-bar').hide();
					self.getEl('grouping_loading').show();
				}

				displayOptions.saveAndRefresh({ isSortUpdate: true });
			}
		});
		this.ownObject(sortingMenu);

		groupMenuBtn = wrapperEl.find('.group-by-menu-trigger');
		groupingMenu = new DeskPRO.UI.Menu({
			triggerElement: groupMenuBtn,
			menuElement: wrapperEl.find('.group-by-menu'),
			onItemClicked: function(info) {
				var item = $(info.itemEl);

				var prop = item.data('group-by')
				var label = item.text().trim();

				// Change the displayed label for some visual feedback
				groupMenuBtn.find('.label').text(label);

				var url = self.meta.refreshUrl;
				url = Orb.appendQueryData(url, 'group_by', prop);

				if (self.meta.viewType == 'list') {
					self.loadNewListviewUrl(url +'&view_type=list');
				} else {
					self.wrapper.find('header.list-grouping-bar').hide();
					self.getEl('grouping_loading').show();
					self.getEl('grouping_bar').hide();
					DeskPRO_Window.loadListPane(url);
				}
			}
		});
		this.ownObject(groupingMenu);

		//------------------------------
		// Export
		//------------------------------

		$scope.openDisplayOptions = function() { displayOptions.open(); };
		$scope.openTableView = function() { self.openTableView(); };
	},


	//#########################################################################
	//# List View
	//#########################################################################

	/**
	 * Opens the current view in the table overlay
	 */
	openTableView: function() {
		var oldlist = this.listview;
		this.listview = new DeskPRO.Agent.TicketList.ListView(this);

		if (oldlist && !oldlist.OBJ_DESTROYED) {
			this.listview.addEvent('ajaxLoaded', function() {
				if (!oldlist.OBJ_DESTROYED) {
					oldlist.destroy();
				}
			});
		}

		this.listview.open();
	},

	//#########################################################################
	//# Paging and refreshing
	//#########################################################################

	_initNavControls: function() {
		var self = this,
			$scope = this.$scope;

		$scope.realtime              = true;
		$scope.refreshCursor         = function() { self.refreshCursor(); };
		$scope.hasUnloadedUpdates    = false;
		$scope.toggleRealtimeUpdates = function() {
			$scope.realtime = !$scope.realtime;
			if ($scope.realtime && $scope.hasUnloadedUpdates) {
				self.refreshCursor();
			}
		};

		$scope.loadPrevCursorPage = function() { if ($scope.hasPrevPage) self.loadPrevCursorPage(); };
		$scope.loadNextCursorPage = function() { if ($scope.hasNextPage) self.loadNextCursorPage(); };
	},

	refreshCursor: function(cursor, invisibleLoad) {
		var self = this,
			$scope = this.$scope,
			$q = this.$q,
			$timeout = this.$timeout,
			def,
			time1 = new Date(),
			time2;

		if (typeof cursor == 'undefined' || cursor === null) {
			cursor = this.realCursorStart - 1;
		}

		console.log('[TicketList] refreshCursor(%d)', cursor);

		if (this.refreshCursorAjax) {
			this.refreshCursorAjax.abort();
			this.refreshCursorAjax = null;
			console.log('[TicketList] refreshCursor :: abort existing request');
		}

		def = new $q.defer();
		if (!invisibleLoad) {
			$scope.refreshCursorLoading = true;
		}

		this.refreshCursorAjax = $.ajax({
			url: this.meta.refreshCursorUrl.replace(/\$cursor/g, cursor),
			dataType: 'json',
			success: function(data) {
				this.refreshCursorAjax = null;
				time2 = new Date();
				console.log('[TicketList] refreshCursor :: done load (%dms) :: %o', time2.getTime() - time1.getTime(), data);

				$scope.hasUnloadedUpdates = false;
				self._handleRefreshCursor(data);
				def.resolve(data);

				$timeout(function() {
					console.log('[TicketList] refreshCursor :: done render (%dms)', (new Date()).getTime() - time2.getTime());
					$scope.refreshCursorLoading = false;
				}, 10);
			},
			error: function() {
				this.refreshCursorAjax = null;
				console.log('[TicketList] refreshCursor :: error :: %o', arguments);
				$scope.refreshCursorLoading = false;
				def.reject();
			}
		});

		return def.promise;
	},

	loadNextCursorPage: function() {
		var $scope = this.$scope;

		var nextCursor = ($scope.pageCursorStart + this.perPage) - 1;

		return this.refreshCursor(nextCursor);
	},

	loadPrevCursorPage: function() {
		var $scope = this.$scope;

		var prevCursor = ($scope.pageCursorStart - this.perPage) - 1;
		if (prevCursor < 0) {
			prevCursor = 0;
		}

		return this.refreshCursor(prevCursor);
	},

	_handleRefreshCursor: function(data) {
		var self = this,
			$scope = this.$scope,
			$timeout = this.$timeout;

		$scope.pauseListAnim = true;
		this.listTicketIds = data.all_ticket_ids;
		$scope.tickets = data.tickets;
		this.updatePageCursorWithTicketId();
		this.realCursorStart = this.$scope.pageCursorStart;

		$timeout(function() {
			$scope.pauseListAnim = false;
		}, 1200);
	}
});


//######################################################################################################################
//######################################################################################################################
//######################################################################################################################

DeskPRO.Agent.PageFragment.List.TicketList.FieldUtil = {

	isSupportedField: function(f) {
		return this.getSupportedFields().indexOf(f) !== -1;
	},

	getSupportedFields: function() {
		return [
			'department', 'category', 'product', 'organization', 'person',
			'language', 'agent', 'agent_team', 'agent_team', 'urgency',
		];
	},

	getFieldValue: function(field, ticket) {
		switch (field) {
			case 'department':
				return ticket.department ? ticket.department.id : null;
			case 'category':
				return ticket.category ? ticket.category.id : null;
			case 'product':
				return ticket.product ? ticket.product.id : null;
			case 'organization':
				return ticket.organization ? ticket.organization.id : null;
			case 'person':
				return ticket.person ? ticket.person.id : null;
			case 'language':
				return ticket.language ? ticket.language.id : null;
			case 'agent':
				return ticket.agent ? ticket.agent.id : null;
			case 'agent_team':
				return ticket.agent_team ? ticket.agent_team.id : null;
			case 'agent_team':
				return ticket.agent_team ? ticket.agent_team.id : null;
			case 'urgency':
				return ticket.urgency ? ticket.urgency : null;
			default:
				console.log("[getFieldValue] Unknown field: %s", field);
				return '__UNKNOWN__';
		}
	},

	checkEquality: function(ticket, field, value) {
		var intValue = parseInt(value) || 0;

		switch (field) {
			case 'department':
				return (ticket.department && ticket.department.id === intValue) || (!ticket.department && intValue === 0);
			case 'category':
				return (ticket.category && ticket.category.id === intValue) || (!ticket.category && intValue === 0);
			case 'product':
				return (ticket.product && ticket.product.id === intValue) || (!ticket.product && intValue === 0);
			case 'organization':
				return (ticket.organization && ticket.organization.id === intValue) || (!ticket.organization && intValue === 0);
			case 'person':
				return (ticket.person && ticket.person.id === intValue) || (!ticket.person && intValue === 0);
			case 'language':
				return (ticket.language && ticket.language.id === intValue) || (!ticket.language && intValue === 0);
			case 'agent':
				return (ticket.agent && ticket.agent.id === intValue) || (!ticket.agent && intValue === 0);
			case 'agent_team':
				return (ticket.agent_team && ticket.agent_team.id === intValue) || (!ticket.agent_team && intValue === 0);
			case 'agent_team':
				return (ticket.agent_team && ticket.agent_team.id === intValue) || (!ticket.agent_team && intValue === 0);
			case 'urgency':
				return ticket.urgency === intValue;
			default:
				console.log("[checkEquality] Unknown field: %s", field);
				return false;
		}
	},

	getOrder: function(ticketA, ticketB, field, dir) {

		dir = dir.toUpperCase();

		var valA = 0,
			valB = 0,
			idDir = dir,
			rDir = dir == 'ASC' ? 'DESC' : 'ASC';

		switch (field) {
			case 'urgency':
				valA = ticketA.urgency || 0;
				valB = ticketB.urgency || 0;
				idDir = rDir;
				break;
			case 'status':
				switch (ticketA.status) {
					case 'awaiting_agent': valA = 1; break;
					case 'awaiting_user':  valA = 2; break;
					case 'resolved':       valA = 3; break;
					case 'closed':         valA = 4; break;
					default:               valA = 5; break;
				}
				switch (ticketB.status) {
					case 'awaiting_agent': valB = 1; break;
					case 'awaiting_user':  valB = 2; break;
					case 'resolved':       valB = 3; break;
					case 'closed':         valB = 4; break;
					default:               valB = 5; break;
				}
			case 'date_created':
				idDir = dir;
				// Will fallback to id
				break;
			case 'date_resolved':
				if (ticketA.date_resolved) {
					valA = ticketA.date_resolved_ts;
				}
				if (ticketB.date_resolved) {
					valB = ticketB.date_resolved_ts;
				}
				break;
			case 'date_closed':
				if (ticketA.date_closed) {
					valA = ticketA.date_closed_ts;
				}
				if (ticketB.date_closed) {
					valB = ticketB.date_closed_ts;
				}
				break;
			case 'total_user_waiting':
				valA = ticketA.total_user_waiting;
				valB = ticketB.total_user_waiting;
				break;
			case 'date_user_waiting':
				if (ticketA.date_user_waiting) {
					valA = ticketA.date_user_waiting_ts;
				}
				if (ticketB.date_user_waiting) {
					valB = ticketB.date_user_waiting_ts;
				}
				break;
			case 'date_last_user_reply':
				if (ticketA.date_last_user_reply) {
					valA = ticketA.date_last_user_reply_ts;
				}
				if (ticketB.date_last_user_reply) {
					valB = ticketB.date_last_user_reply_ts;
				}
				break;
			case 'date_last_agent_reply':
				if (ticketA.date_last_agent_reply) {
					valA = ticketA.date_last_agent_reply_ts;
				}
				if (ticketB.date_last_agent_reply) {
					valB = ticketB.date_last_agent_reply_ts;
				}
				break;
			case 'date_last_reply':
				valA = Math.max(ticketA.date_last_user_reply_ts || 0, ticketA.date_last_agent_reply_ts || 0, ticketA.date_created_ts || 0);
				valB = Math.max(ticketB.date_last_user_reply_ts || 0, ticketB.date_last_agent_reply_ts || 0, ticketB.date_created_ts || 0);
				break;
			case 'priority':
				valA = ticketA.priority ? ticketA.priority.priority : 0;
				valB = ticketB.priority ? ticketB.priority.priority : 0;
				idDir = rDir;
				break;
		}

		if (valA === valB) {
			valA = ticketA.id;
			valB = ticketB.id;
			dir = idDir;
		}

		if (dir == 'ASC') {
			return valA < valB ? -1 : 1;
		} else {
			return valA < valB ? 1 : -1;
		}
	}
};


//######################################################################################################################
//######################################################################################################################
//######################################################################################################################

DeskPRO.Agent.PageFragment.List.TicketList.MassActions = new Orb.Class({
	Implements: [Orb.Util.Events, Orb.Util.Options],

	initialize: function(options)  {
		this.options = {
			/**
			 * The HTML element with the actual controls etc we'll use for this
			 * Defaults to 'wrapper .mass-actions-overlay'
			 */
			templateElement: null,

			/**
			 * Scope of the list
			 */
			$scope: null
		};

		this.setOptions(options);
		this.$scope = this.options.$scope;

		this.realtimeStatus = this.$scope.realtime;
		this.$scope.realtime = false;

		if (this.realtimeStatus) {
			this.$scope.halfrealtime = true;
		}

		this.$scope.massActionsOpen = true;

		this.wrapperEl = this.options.templateElement;
		if(!this.wrapperEl.length) {
			return;
		}

		this._formUpdatedDebounce = _.debounce(this._formUpdated, 500);

		this._resetWrapper();

		this.backdropEls = null;
	},

	updateUi: function() {
		if (this.scrollerHandler) {
			this.scrollerHandler.updateSize();
		}
	},

	_resetWrapper: function() {
		if (this.wrapper) {
			this.wrapper.remove();
		}

		if (!this.wrapperEl.is('script')) {
			this.wrapper = $('<div/>').addClass('mass-actions-overlay-container mass-actions').data('base-id', this.wrapperEl.data('base-id')).data('upload-url', this.wrapperEl.data('upload-url'));
			var wrapperHtml = this.wrapperEl.html();
			this.wrapper.html(wrapperHtml);
		} else {
			var wrapperHtml = DeskPRO_Window.util.getPlainTpl(this.wrapperEl);
			this.wrapper = $(wrapperHtml);
			this.wrapper.detach().appendTo('body');
		}

		this.wrapper.find('.with-scroll-handler, .scroll-setup, .scroll-draw').removeClass('with-scroll-handler scroll-setup scroll-draw');

		this.countEl = $('.selected-tickets-count', this.wrapper);
		DP.select($('select.macro', this.wrapper));

		DeskPRO_Window.initInterfaceLayerEvents(this.wrapper);
		var scrollEl = $('.with-scrollbar', this.wrapper).first();
		if (scrollEl.length) {
			this.scrollerHandler = new DeskPRO.Agent.ScrollerHandler(null, scrollEl, {
				showEvent: 'show',
				hideEvent: 'hide'
			});
		}
	},

	/**
	 * Resets the wrapper back to the original, and then runs all of the init again.
	 */
	reset: function() {
		var wasopen = this.isOpen();
		this.close();

		this._resetWrapper();

		this._hasInit = false;

		if (wasopen) {
			this.open();
		}
	},


	/**
	 * Get the main wrapper element around the mass actions UI controls.
	 *
	 * @return {jQuery}
	 */
	getElement: function() {
		return this.wrapper;
	},


	/**
	 * Form updated, fire the updated callback
	 */
	_formUpdated: function() {
		var info = {};
		var changes = [];

		this.getActionFormValues(changes, false, info);
		this.fireEvent('formUpdated', [changes]);
	},


	/**
	 * Inits the overlay controls lazily on first open
	 */
	_initOverlay: function() {
		var self = this;
		if (this._hasInit) return;
		this._hasInit = true;

		this.wrapper.detach().appendTo('body');
		this.wrapper.css('z-index', '21001');

		this.baseId = this.wrapper.data('base-id');

		this.wrapper.on('click', function(ev) {
			ev.stopPropagation();
		});

		// Three backdrops to surround each side of the list pane: left, right, top
		var back1 = $('<div class="backdrop mass-actions" />');
		var back2 = $('<div class="backdrop mass-actions" />');
		var back3 = $('<div class="backdrop mass-actions" />');
		this.backdropEls = $([back1.get(0), back2.get(0), back3.get(0)]);
		this.backdropEls.css('z-index', '21000').hide().appendTo('body');

		this.backdropEls.on('click', (function(ev) {
			ev.stopPropagation();
			this.close();
		}).bind(this));

		$('header .close-trigger', this.wrapper).first().on('click', (function(ev) {
			ev.stopPropagation();
			ev.preventDefault();
			this.close();
		}).bind(this));

		//------------------------------
		// Convert radios
		//------------------------------

		var tpl = DeskPRO_Window.util.getPlainTpl($('.radio-tpl', this.wrapper));

		var groupedRadios = {};
		$(':radio.button-toggle', this.wrapper).each(function() {
			var name = $(this).attr('name');
			if (!groupedRadios[name]) {
				groupedRadios[name] = [];
			}

			groupedRadios[name].push(this);
		});

		Object.each(groupedRadios, function(els) {
			var newEls = [];
			els = $(els);

			var clickFn = function() {
				var boundId = $(this).data('bound-id');
				var radio = $('#' + boundId);

				// Toggle off already checked (ie none selected now)
				if (radio.is(':checked')) {
					radio.attr('checked', false);
					newEls.removeClass('radio-on');

					// Normal radio behavior
				} else {
					radio.attr('checked', true);
					newEls.removeClass('radio-on');
					$(this).addClass('radio-on');
				}

				self._formUpdatedDebounce();
			};

			els.each(function() {

				var wrapper = $(this).parent();
				var title = $('.radio-title', wrapper).text().trim();

				var newEl = $(tpl)
				newEl.addClass($(this).data('attach-class'));
				$('.radio-title', newEl).text(title);

				if (!$(this).attr('id')) {
					$(this).attr('id', Orb.getUniqueId());
				}

				newEl.data('bound-id', $(this).attr('id'));

				newEl.on('click', clickFn);

				wrapper.hide();
				newEl.insertAfter(wrapper);

				newEls.push(newEl.get(0));
			});

			newEls = $(newEls);
		});

		//------------------------------
		// Attach change listeners
		//------------------------------


		$('select.macro', this.wrapper).on('change', function() {
			self.loadMacro($(this).val());
			self._formUpdatedDebounce();
		});

		$('.apply-actions', this.wrapper).on('click', (function(ev) {
			this.apply();
		}).bind(this));

		//------------------------------
		// Reply Box
		//------------------------------

		var textarea = this.getElById('replybox_txt'), isWysiwyg = false;
		this.textarea = textarea;

		if (DeskPRO_Window.canUseAgentReplyRte()) {

			var sig = this.wrapper.find('textarea.signature-value-html').val() || "";
			sig = sig.replace(/<div class="dp-signature-start">([\w\W]*)<\/div>/, '<p class="dp-signature-start">$1</p>');

			if (sig) {
				textarea.val(($.browser.msie ? '<p></p><p></p>' : '<p><br></p><p><br></p>') + '\n\n' + sig);
			}

			isWysiwyg = true;
			self.getElById('is_html_reply').val('1');

			DeskPRO_Window.initRteAgentReply(textarea, {
				defaultIsHtml: true,
				inlineHiddenPosition: this.getElById('is_html_reply'),
				minHeight: 120,
				callback: function(obj) {
					obj.addBtnFirst('dp_attach', 'Click here to attach a file. You may also drag a file from your computer desktop into this reply area to upload attachments faster.', function(){});
					obj.addBtnAfter('dp_attach', 'dp_snippets', 'Open snippets', function(){});
					obj.addBtnSeparatorAfter('dp_attach');

					var snippetBtn = obj.$toolbar.find('.redactor_btn_dp_snippets').closest('li');
					snippetBtn.addClass('snippets').find('a').html('<span class="show-key-shortcut">S</span>nippets');
					snippetBtn.on('click', function(ev) {
						Orb.cancelEvent(ev);
						self.snippetsViewer.open();
					});

					var attachBtn = obj.$toolbar.find('.redactor_btn_dp_attach').closest('li');
					attachBtn.addClass('attach');
					attachBtn.find('a').text('Attach').append('<input type="file" class="file" name="file-upload" />');

					obj.addBtnSeparatorAfter('dp_snippets');
				}
			});
			this.getElById('is_html_reply').val(1);
		}

		//------------------------------
		// Snippets Viewer
		//------------------------------

		this.snippetsViewer = new DeskPRO.Agent.Widget.SnippetViewer({
			driver: DeskPRO_Window.ticketSnippetDriver,
			onBeforeOpen: function() {
				if (isWysiwyg && textarea.data('redactor')) {
					try {
						textarea.data('redactor').saveSelection();
					} catch (e) {}
				}
			},
			onSnippetClick: function(info) {

				var snippetId    = info.snippetId;
				var snippetCode  = info.snippetCode;

				var agentText;
				var defaultText;
				var useText;
				var result;

				Array.each(snippetCode, function(info) {
					if (info.value) {
						if (info.language_id == DESKPRO_PERSON_LANG_ID) {
							agentText = info.value;
						}
						if (info.language_id == DESKPRO_DEFAULT_LANG_ID) {
							defaultText = info.value;
						}
						useText = info.value;
					}
				});

				if (agentText) {
					useText = agentText;
				} else if (defaultText) {
					useText = defaultText;
				}

				result = useText || '';

				if (isWysiwyg && textarea.data('redactor')) {
					try {
						textarea.data('redactor').restoreSelection();
						textarea.data('redactor').setBuffer();
					} catch (e) {}

					var html = result;
					html = html.replace(/<\/p>\s*<p>/g, '<br/>');
					html = html.replace(/^<p>/, '');
					html = html.replace(/<\/p>$/, '');
					textarea.data('redactor').insertHtml(html);
				} else {
					self.page.insertTextInReply(result);
				}

				self.snippetsViewer.close();
			}
		});

		//------------------------------
		// Upload handling
		//------------------------------

		DeskPRO_Window.util.fileupload(this.wrapper, {
			url: this.wrapper.data('upload-url'),
			uploadTemplate: $('.template-upload', this.replyBox),
			downloadTemplate: $('.template-download', this.replyBox)
		});

		var sels = this.wrapper.find('select.dpe_select');

		window.setTimeout(function() {
			sels.each(function() {
				DP.select($(this));
			});
		}, 150);

		this.wrapper.bind('fileuploaddone', function() {
			self.getElById('attach_row').fadeIn();
			self.wrapper.find('[name="attach\\[\\]"]').each(function() {
				$(this).name('actions[reply][attach_ids][]');
			});
		});
		this.wrapper.bind('fileuploadstart', function() {
			self.getElById('attach_row').fadeIn();
			self.updatePositions();
		});

		this.wrapper.on('click', '.remove-attach-trigger', function() {

			var row = $(this).closest('li');
			row.remove();

			var rows = $('ul.files li', self.getElById('attach_row'));
			if (!rows.length) {
				self.getElById('attach_row').hide().addClass('is-hidden');
			}

			self.updatePositions();
		});

		if (this.assignOptionBox) {
			this.assignOptionBox.destroy();
		}

		var add = $('.other-properties-wrapper', this.wrapper);

		// Remove all the stuff we have layed out in a different way
		// on this popup
		$('div.type', add).each(function() {
			var type = $(this).data('rule-type');
			if (!type) return;

			if (type == 'add_labels' || type == 'remove_labels' || type.indexOf('ticket_field[') !== -1 || type.indexOf('people_field[') !== -1) {

			} else {
				$(this).remove();
			}
			self.updatePositions();
		});

		this.actionsEditor = new DeskPRO.Form.RuleBuilder($('.actions-builder-tpl', add));

		var actList = $('.other-properties-wrapper', this.wrapper);
		$('.add-term-row', add).show().on('click', function() {
			var x = Orb.getUniqueId();
			var basename = 'actions_set['+x+']';
			self.actionsEditor.addNewRow($('.search-terms', actList), basename);
			self.updatePositions();
		});

		this.wrapper.find('input, select, textarea').on('click change blur focus', function() {
			self._formUpdatedDebounce();
		});
	},

	getElById: function(id) {
		return $('#' + this.baseId + '_' + id);
	},

	getActionFormValues: function(appendArray, isApply, info) {
		var self = this;
		appendArray = appendArray || [];

		if (!info) info = {};
		info.actionsCount = 0;

		if (this.wrapper.find('select.macro_id')[0] && this.wrapper.find('select.macro_id').val() != '0') {
			appendArray.push({
				name: 'run_macro_id',
				value: this.wrapper.find('select.macro_id').val()
			});
			info.actionsCount = 1;
			return appendArray;
		}

		$('input, select, textarea', this.wrapper).filter('[name^="actions["], [name^="actions_set["]').each(function() {

			var val = $(this).val(), name = $(this).attr('name');

			if (!val) {
				val = '';
			}

			if (val == '-1') {
				val = '';
			}

			if ($(this).is(':radio, :checkbox')) {
				if (!$(this).is(':checked')) {
					return;
				}
			}

			if (val === '') {
				return;
			}

			// Dont send reply type when we're just fetching previews
			if (!isApply && name == 'actions[reply][reply_text]') {
				return;
			}
			if (!isApply && name == 'actions[reply][is_html]') {
				return;
			}

			// Empty reply, dont add it
			if (name == 'actions[reply][reply_text]') {
				var copy = $.trim(self.wrapper.find('.ticketreply').find('.redactor_editor').text()).replace(/\s/g, ' ');
				var tmp = $('<div/>').html(self.wrapper.find('textarea.signature-value-html').val());
				var sig = $.trim(tmp.text()).replace(/\s/g, ' ');

				if (!copy || copy == sig) {
					return;
				}
			}

			appendArray.push({
				name: name,
				value: val
			});

			info.actionsCount++;
		});

		return appendArray;
	},

	/**
	 * Apply the changes
	 */
	apply: function() {
		var self = this;
		var formData = [];

		var formDataInfo = {
			checkedCount: 0,
			actionsCount: 0
		};

		var ticketIds = this.options.getCheckedIds();
		formDataInfo.checkedCount = ticketIds.length;
		if (!formDataInfo.checkedCount) {
			return;
		}

		ticketIds.forEach(function(tid) {
			formData.push({ name: 'result_ids[]', value: tid });
		});

		formData.push({ name:'return_data', value:'1'});

		this.getActionFormValues(formData, true, formDataInfo);

		// If we dont have any tickets or actions then theres nothing to do
		if (!formDataInfo.checkedCount || !formDataInfo.actionsCount) {
			return;
		}

		this.wrapper.addClass('loading');

		var statusUpdate = this.wrapper.find('input[name="actions[status]"]:checked').val();

		DeskPRO_Window.util.ajaxWithClientMessages({
			url: BASE_URL + 'agent/ticket-search/ajax-save-actions',
			type: 'POST',
			data: formData,
			dataType: 'json',
			context: this,
			success: function(data) {
				self.wrapper.removeClass('loading');

				this.close();

				this.fireEvent('postApply', [this, data, formDataInfo]);

				if (data && data.failed_tickets && data.failed_tickets.length) {
					DeskPRO_Window.showAlert('Note: ' + data.failed_tickets.length + ' tickets were not updated because you do not have permission to make the requested changed.');
				}

				if (statusUpdate === 'hidden.deleted' || statusUpdate === 'hidden.spam') {
					// hide any open tickets
					$.each(data.success_tickets, function(k, ticketId) {
						var tab = DeskPRO_Window.getTabWatcher().findTab('ticket', function(tab) {
							return (tab && tab.page && tab.page && tab.page.meta.ticket_id == ticketId);
						});
						if (tab) {
							DeskPRO_Window.removePage(tab.page);
						}
					});
				}
			}
		});

	},


	/**
	 * Update the positions of the elements
	 */
	updatePositions: function() {

		//------------------------------
		// The wrapper overlaps the content pane section
		//------------------------------

		var pos = $('#dp_content').offset();
		var top = pos.top - 4;

		var bottom = 10;
		var height = '';

		var scrollContent = $('.scroll-content', this.wrapper).first();
		var contentH = false;
		var hasHeader = !!($('> section > header', this.wrapper).length);
		var hasFooter = !!($('> section > footer', this.wrapper).length);

		if (scrollContent.length) {
			contentH = scrollContent.height();
			if (hasHeader) {
				contentH += 36;
			}
			if (hasFooter) {
				contentH += 45;
			}

			contentH += 31;
		}

		if (hasHeader) $('> section > article', this.wrapper).removeClass('no-header');
		else $('> section > article', this.wrapper).addClass('no-header');

		if (hasFooter) $('> section > article', this.wrapper).removeClass('no-footer');
		else $('> section > article', this.wrapper).addClass('no-footer');

		if (contentH < 350) {
			contentH = 350;
		}

		var maxH = $(window).height() - top - 10;

		if (contentH && contentH < maxH) {
			bottom = '';
			height = contentH;
		}

		this.wrapper.css({
			top: pos.top - 4,
			left: pos.left + 8,
			right: 3,
			bottom: bottom,
			height: height
		});

		//------------------------------
		// The backdrops surround each side of the list pane
		//------------------------------

		var leftEnd = 269; // Where the left ends (aka where listpane starts)
		var topEnd = 50; // Where the top ends (aka header height)
		var contentStart = pos.left;

		if (!this.options.isListView) {
			this.backdropEls.eq(0).css({
				top: 0,
				width: leftEnd,
				bottom: 0,
				left: 0
			});

			this.backdropEls.eq(1).css({
				top: 0,
				height: topEnd,
				width: contentStart - leftEnd,
				left: leftEnd
			});

			this.backdropEls.eq(2).css({
				top: 0,
				right: 0,
				bottom: 0,
				left: contentStart
			});
		}

		this.updateUi();
	},


	/**
	 * Load a macro into the form
	 */
	loadMacro: function(macro_id) {

		var macroEl = $('.macro-options', this.wrapper);
		var inputActionsEl = $('.actions-input', this.wrapper);

		macro_id = parseInt(macro_id);
		if (!macro_id) {
			macroEl.hide();
			macroEl.find('ul.actions-list').empty();
			macroEl.find('input.macro_id').remove();
			inputActionsEl.show();
			this.updateUi();
			this.updatePositions();
			return;
		}

		var macroBtnEl = $('div.macro-load', this.wrapper).addClass('loading');

		$.ajax({
			url: BASE_URL + 'agent/ticket-search/ajax-get-macro-actions',
			data: { macro_id: macro_id },
			type: 'GET',
			dataType: 'json',
			context: this,
			success: function(data) {

				inputActionsEl.hide();
				macroEl.show();

				var input = $('<input type="hidden" class="macro_id" name="run_macro_id" />');
				input.val(macro_id);
				input.appendTo(macroEl);

				var ul = macroEl.find('ul.actions-list');
				ul.empty();

				Array.each(data.descriptions, function(desc) {
					var li = $('<li />');
					li.html(desc);

					ul.append(li);
				});

				macroBtnEl.removeClass('loading');

				this.updateUi();
				this.updatePositions();
			}
		});

		this.updatePositions();
	},


	/**
	 * Is the overlay currently open?
	 *
	 * @return {Boolean}
	 */
	isOpen: function() {
		if (!this._hasInit || !this.wrapper.is('.open')) {
			return false;
		}

		return true;
	},


	/**
	 * Open this overlay
	 */
	open: function() {
		if (!this.wrapper || !this.wrapper[0]) {
			this._resetWrapper();
		}

		this._initOverlay();

		this.updatePositions();
		DeskPRO_Window.layout.addEvent('resized', this.updatePositions, this);
		this.wrapper.addClass('open');
		this.backdropEls.show();

		this.wrapper.addClass('open').show();

		this.updatePositions();
	},


	/**
	 * Close the overlay
	 */
	close: function() {
		if (!this.isOpen()) {
			return false;
		}

		DeskPRO_Window.layout.removeEvent('resized', this.updatePositions, this);
		this.wrapper.removeClass('open');
		this.backdropEls.hide();
		this.fireEvent('closed', [this]);

		if (this.options.resetOnClose) {
			this.reset();
		}

		this.$scope.halfrealtime = false;
		this.$scope.massActionsOpen = false;
		if (this.realtimeStatus) {
			this.$scope.toggleRealtimeUpdates();
		}
		this.$scope.$safeApply();
	},


	destroy: function() {
		if (this._hasInit) {
			this.wrapper.remove();
			this.backdropEls.remove();
		}

		if (this.textarea && this.textarea.data('redactor')) {
			this.textarea.redactor('destroy');
		}
	}
});
