<?php

/**
 * The upgrade paths for each version. The key is the starting
 * version and the value is the next version.
 *
 * Note that the upgrade paths for different branches of DeskPRO may be
 * different. For example, a release made for branch 3.0.x after 3.1.x
 * is released might mean the 3.1.x upgrade path would skip that upgrade.
 * The upgrade scripts would need to take into account any changes.
 *
 * @array
 */
$upgrade_paths = array(
	3000000 => 3000001,		// 3.0.0 Alpha 1 => 3.0.0 Beta 1
	3000001 => 3000002,     // 3.0.1 Beta 1 => 3.0.1 Beta 2
	3000002 => 3000003,     // 3.0.1 Beta 2 => 3.0.1 Beta 3
	3000003 => 3000004,     // 3.0.1 Beta 3 => 3.0.1 Beta RC1
	3000004 => 3000005,     // 3.0.1 Beta RC1 => 3.0.1 Beta RC2
	3000005 => 3000006,     // 3.0.1 Beta RC2 => 3.0.1 Gold
	3000006 => 3000101,     // 3.0.1 Gold => 3.0.1
	3000101 => 3000201,     // 3.0.1 => 3.0.2
	3000201 => 3000301,     // 3.0.2 => 3.0.3

	3000301 => 3010001,     // 3.0.3 => 3.1.0 Beta 1
	3000401 => 3010001,     // 3.0.4 => 3.1.0 Beta 1

	3010001 => 3010002,     // 3.1.0 Beta 1 => 3.1.0 RC1
	3010002 => 3010003,     // 3.1.0 RC 1 => 3.1.0 Gold
	3010003 => 3010101,     // 3.1.0 Gold => 3.1.1

	3010101 => 3010201,     // 3.1.1 => 3.1.2
	3010201 => 3020001,     // 3.1.2 => 3.2.0
	3010301 => 3020001,     // 3.1.3 => 3.2.0
	3010401 => 3020001,     // 3.1.4 => 3.2.0
	3010501 => 3020001,     // 3.1.5 => 3.2.0

	3020001 => 3020101,     // 3.2.0 => 3.2.1
	3020101 => 3020201,     // 3.2.1 => 3.2.2

	3020201 => 3030001,     // 3.2.1 => 3.3.0
);


/**
 * A map of which build number represents which version.
 *
 * @array
 */
$deskpro_versions = array(
	3000000 => '3_0_0_alpha_1',
	3000001 => '3_0_0_beta_1',
	3000002 => '3_0_0_beta_2',
	3000003 => '3_0_0_beta_3',
	3000004 => '3_0_0_rc1',
	3000005 => '3_0_0_rc2',
	3000006 => '3_0_0',
	3000101 => '3_0_1',
	3000201 => '3_0_2',
	3000301 => '3_0_3',
	3000401 => '3_0_4',
	3010001 => '3_1_0_beta_1',
	3010002 => '3_1_0_rc1',
	3010003 => '3_1_0',
	3010101 => '3_1_1',
	3010201 => '3_1_2',
	3010301 => '3_1_3',
	3010401 => '3_1_4',
	3010501 => '3_1_5',
	3020001 => '3_2_0',
	3020101 => '3_2_1',
	3020201 => '3_2_2',
	3030001 => '3_3_0',
);


/**
 * A map of which build numbers represents which readable version name.
 *
 * @array
 */
$deskpro_versions_names = array(
	3000000 => '3.0.0 Alpha 1',
	3000001 => '3.0.0 Beta 1',
	3000002 => '3.0.0 Beta 2',
	3000003 => '3.0.0 Beta 3',
	3000004 => '3.0.0 RC1',
	3000005 => '3.0.0 RC2',
	3000006 => '3.0.0',
	3000101 => '3.0.1',
	3000201 => '3.0.2',
	3000301 => '3.0.3',
	3000401 => '3.0.4',
	3010001 => '3.1.0 Beta 1',
	3010002 => '3.1.0 RC 1',
	3010003 => '3.1.0',
	3010101 => '3.1.1',
	3010201 => '3.1.2',
	3010301 => '3.1.3',
	3010401 => '3.1.4',
	3010501 => '3.1.5',
	3020001 => '3.2.0',
	3020101 => '3.2.1',
	3020201 => '3.2.2',
	3030001 => '3.3.0',
);


/**
 * A map of old build numbers to their new build numbers
 *
 * @array
 */
$legacy_versions = array(
	1 => 3000000,
	2 => 3000001,
	3 => 3000002,
	4 => 3000003,
	5 => 3000004,
	6 => 3000005,
	7 => 3000006,
	8 => 3000101,
	9 => 3000201,
	10 => 3000301,
);
