<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
 * DeskPRO
 *
 * @package DeskPRO
 * @subpackage UserBundle
 */

namespace Application\UserBundle\Controller\Helper;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;

use Orb\Util\Arrays;
use Orb\Util\Util;

class Comments
{
	protected $entity;
	protected $page_url;
	protected $adapter;

	/**
	 * Creates a new instance of this comments helper using the adapter
	 * defined in settings. Or returns null if no adapter is set
	 *
	 * @param  $page_url
	 * @param  $entity
	 * @return Comments
	 */
	public static function create($entity)
	{
		if (App::getSetting('core.comments_adapter') == 'disqus') {
			$adapter = 'DisqusComments';
		} elseif (App::getSetting('core.comments_adapter') == 'facebook') {
			$adapter = 'FacebookComments';
		} else {
			return null;
		}

		return new self($adapter, $entity);
	}

	/**
	 * @param string $adapter  A comment adapter, or a string of an base adapter classname
	 * @param string $page_url The permalink to the page
	 * @param Entity $entity   The entity we're adding comments to
	 */
	public function __construct($adapter, $entity)
	{
		$this->entity = $entity;

		if (is_string($adapter)) {
			$class = 'Application\\UserBundle\\Controller\\Helper\\CommentsAdapter\\' . $adapter;
			$adapter = new $class($entity);
		}

		$this->adapter = $adapter;
	}



	/**
	 * Get the HTML block from the adapter
	 *
	 * @return string
	 */
	public function getHtml()
	{
		return $this->adapter->getHtml();
	}
}
