<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
 * DeskPRO
 *
 * @package DeskPRO
 * @category Tickets
 */

namespace Application\DeskPRO\Tickets\TicketChangeInspector\LogActions;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;

class Urgency extends AbstractLogAction
{
	protected $old_urgency;
	protected $new_urgency;
	protected $reset_next_reply = null;

	public function __construct($old_urgency, $new_urgency, $reset_next_reply = null)
	{
		$this->old_urgency = $old_urgency;
		$this->new_urgency = $new_urgency;
		$this->reset_next_reply = $reset_next_reply;
	}

	public function getLogName()
	{
		return 'changed_urgency';
	}

	public function getLogDetails()
	{
		if ($this->old_urgency == $this->new_urgency) {
			return array();
		}

		return array(
			'id_before' => $this->old_urgency ?: null,
			'id_after'  => $this->new_urgency ?: null,

			'old_urgency' => $this->old_urgency,
			'new_urgency' => $this->new_urgency,
			'reset_next_reply' => $this->reset_next_reply
		);
	}

	public function getEventType()
	{
		return 'property';
	}
}
