<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
 * DeskPRO
 *
 * @package DeskPRO
 * @category Tickets
 */

namespace Application\DeskPRO\Tickets\TicketChangeInspector\LogActions;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;

class Merge extends AbstractLogAction
{
	protected $ticket;
	protected $old_ticket_id;
	protected $lost;

	public function __construct($ticket, $old_ticket_id, array $lost = array())
	{
		$this->ticket = $ticket;
		$this->old_ticket_id = $old_ticket_id;
		$this->lost = $lost;
	}

	public function getLogName()
	{
		return 'merged';
	}

	public function getLogDetails()
	{
		return array(
			'id_before' => $this->old_ticket_id ?: null,
			'id_after'  => $this->ticket['id'] ?: null,
			'lost'      => $this->lost,
			'merged'    => 1,
		);
	}

	public function getEventType()
	{
		return 'ticket_merge';
	}
}
