<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
* DeskPRO
*
* @package DeskPRO
*/

namespace Application\DeskPRO\CustomFields;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;
use Symfony\Component\DependencyInjection\ContainerAware;

/**
 * @deprecated Use the FieldFanager with the field manager service
 */
class TicketFields extends AbstractFields
{
	const ENTITY_CLASS = 'Application\\DeskPRO\\Entity\\CustomDefTicket';
	const ENTITY_NAME  = 'DeskPRO:CustomDefTicket';

	/**
	 * @var \Application\DeskPRO\CustomFields\TicketFieldManager
	 */
	private $fm;

	public function __construct()
	{
		$this->fm = App::getContainer()->getSystemService('TicketFieldsManager');
	}

	public function userDisplayRuleFilter($ticket_fields)
	{
		$display_elements = App::getOrm()->createQuery("
			SELECT d
			FROM DeskPRO:DepartmentTicketDisplay d
			WHERE d.is_agent_only = ?1
			ORDER BY d.display_order ASC
		")->execute(array(1=>false));
	}

	public function getFieldsDisplayArray($field_defs, $data_structured = array(), $field_group = null)
	{
		return $this->fm->getDisplayArray($data_structured, $field_group);
	}

	public function getFields()
	{
		return $this->fm->getFields();
	}

	public function getEnabledFields()
	{
		return $this->fm->getFields();
	}

	public function getFieldFromId($field_id)
	{
		return $this->fm->getFieldFromId($field_id);
	}
}
