<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
 * DeskPRO
 *
 * @package DeskPRO
 */

namespace Application\DeskPRO\Command;

use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Output\Output;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;

class GenRandomEmailCommand extends \Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand
{
	protected function configure()
	{
		$this->setName('dp:gen-rand-email');
		$this->addOption('from-email', null, InputOption::VALUE_REQUIRED);
		$this->addOption('to-email', null, InputOption::VALUE_REQUIRED);
		$this->addOption('with-owl', null, InputOption::VALUE_NONE);
		$this->addOption('owl-size', null, InputOption::VALUE_REQUIRED);
		$this->addOption('real-send', null, InputOption::VALUE_NONE);
		$this->addOption('subject', null, InputOption::VALUE_NONE);
		$this->addOption('fwd-for', null, InputOption::VALUE_REQUIRED);
	}

	protected function execute(InputInterface $input, OutputInterface $output)
	{
		$fwd_for = $input->getOption('fwd-for') ? $input->getOption('fwd-for') : false;
		$subject = $input->getOption('subject') ?: 'Test Email - %TIME%';

		$email_pre = "";

		$email_pre_html = "";
		if ($email_pre) {
			$email_pre_html = "<div>" . nl2br($email_pre) . "</div>";
		}

		$fwd_footer = '';
		$fwd_footer_html = '';
		if ($fwd_for) {
			$fwd_footer = "\n\n----- Forwarded Message -----\nFrom: $fwd_for\nSubject: $subject\n\nOriginal message from the user\n\n";
			$fwd_footer_html = "<div>" . nl2br($fwd_footer) . "</div>";
			$subject = "FW: " . $subject;
		}

		if (!$input->getOption('with-owl')) {
			$source = <<<SRC
Date: Mon, 10 Dec 2012 19:15:33 +0000
From: %FROM_EMAIL%
To: %TO_EMAIL%
Message-ID: <144FD598151749D98C378FCF8B2E03C2@gmail.com>
Subject: $subject
X-Mailer: sparrow 1.6.4 (build 1176)
MIME-Version: 1.0
Content-Type: multipart/alternative; boundary="50c634de_3222e7cd_af2f"

--50c634de_3222e7cd_af2f
Content-Type: text/plain; charset="utf-8"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline

$email_pre
Test Subject - 2012-12-10 19:15:29
$fwd_footer

-- Christopher


--50c634de_3222e7cd_af2f
Content-Type: text/html; charset="utf-8"
Content-Transfer-Encoding: quoted-printable
Content-Disposition: inline

$email_pre_html
<div>Test Message</div>
%MSG_UID%
$fwd_footer_html

--50c634de_3222e7cd_af2f--

SRC;
		} else {

			$file = <<<SRC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==
SRC;

			if ($input->getOption('owl-size')) {
				$file = str_repeat($file, (int)$input->getOption('owl-size'));
			}

			$source = <<<SRC
Received: from [172.18.24.247] (iw-01.clients.vorboss.net. [194.8.255.114])
        by mx.google.com with ESMTPS id t17sm17495468wiv.6.2012.12.11.10.40.53
        (version=TLSv1/SSLv3 cipher=OTHER);
        Tue, 11 Dec 2012 10:40:54 -0800 (PST)
Date: Tue, 11 Dec 2012 18:40:52 +0000
From: %FROM_EMAIL%
To: %TO_EMAIL%
Message-ID: <B5522AAC086547DFB50EDB640A75AE8E@deskpro.com>
Subject: Test Email - %TIME%
MIME-Version: 1.0
Content-Type: multipart/mixed; boundary="50c77e34_725a06fb_dfd0"

--50c77e34_725a06fb_dfd0
Content-Type: multipart/alternative; boundary="50c77e34_1d4ed43b_dfd0"

--50c77e34_1d4ed43b_dfd0
Content-Type: text/plain; charset="utf-8"
Content-Transfer-Encoding: 7bit
Content-Disposition: inline

$email_pre
Test Message
%MSG_UID%
$fwd_footer


--50c77e34_1d4ed43b_dfd0
Content-Type: text/html; charset="utf-8"
Content-Transfer-Encoding: quoted-printable
Content-Disposition: inline

$email_pre_html
<div>Test Message</div>
%MSG_UID%
$fwd_footer_html

--50c77e34_1d4ed43b_dfd0--

--50c77e34_725a06fb_dfd0
Content-Type: image/jpeg
Content-Transfer-Encoding: base64
Content-Disposition: attachment; filename="eastern-owl.jpeg"

$file

--50c77e34_725a06fb_dfd0--
SRC;

		}
		$from_email = $input->getOption('from-email');
		$to_email   = $input->getOption('to-email');
		$time       = date('Y-m-d H:i:s');

		if ($input->getOption('real-send')) {
			$message = App::getMailer()->createMessage();
			$message->setTo($to_email);
			$message->setFrom($from_email);
			$message->setSubject('Test Email - ' . $time);
			$message->getBody("Test Message\n\n" . uniqid('eml-', true));

			$tr = new \Application\DeskPRO\Entity\EmailTransport();
			$tr->match_type = 'all';
			$tr->title = 'contact';
			$tr->transport_type = 'mail';

			$message->setForceTransport($tr);

			App::getMailer()->send($message);

			echo "Message Sent\n";
		} else {
			$source = str_replace('%FROM_EMAIL%', $from_email, $source);
			$source = str_replace('%TO_EMAIL%', $to_email, $source);
			$source = str_replace('%TIME%', $time, $source);
			$source = str_replace('%MSG_UID%', uniqid('eml-', true), $source);

			echo $source;
		}
	}
}