<?php
/**************************************************************************\
| DeskPRO (r) has been developed by DeskPRO Ltd. http://www.deskpro.com/   |
| a British company located in London, England.                            |
|                                                                          |
| All source code and content Copyright (c) 2012, DeskPRO Ltd.             |
|                                                                          |
| The license agreement under which this software is released              |
| can be found at http://www.deskpro.com/license                           |
|                                                                          |
| By using this software, you acknowledge having read the license          |
| and agree to be bound thereby.                                           |
|                                                                          |
| Please note that DeskPRO is not free software. We release the full       |
| source code for our software because we trust our users to pay us for    |
| the huge investment in time and energy that has gone into both creating  |
| this software and supporting our customers. By providing the source code |
| we preserve our customers' ability to modify, audit and learn from our   |
| work. We have been developing DeskPRO since 2001, please help us make it |
| another decade.                                                          |
|                                                                          |
| Like the work you see? Think you could make it better? We are always     |
| looking for great developers to join us: http://www.deskpro.com/jobs/    |
|                                                                          |
| ~ Thanks, Everyone at Team DeskPRO                                       |
\**************************************************************************/

/**
 * DeskPRO
 *
 * @package DeskPRO
 * @category Controller
 */

namespace Application\DeskPRO\ClientMessage\MessageHandler;

use Application\DeskPRO\App;
use Application\DeskPRO\Entity;

/**
 * A message handler decides how to take a message and compose a suitable
 * data packet for the client. For example, it might just be an ID so the
 * client can callback for full data, or it might be all the data now etc.
 */
abstract class AbstractMessageHandler
{
	/**
	 * @var Application\DeskPRO\Entity\ClientMessage
	 */
	protected $message;

	public function __construct(Entity\ClientMessage $message)
	{
		$this->message = $message;
	}

	/**
	 * Get the message to give the client.
	 *
	 * @param  $context
	 * @return mixed
	 */
	abstract function getMessage($context);
}
